/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.doclet.markdown;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.devkit.doclet.markdown.HTMLToken;
import org.mule.devkit.doclet.markdown.Replacement;

public class TextEditor {
    private StringBuffer text;

    public TextEditor(CharSequence text) {
        this.text = new StringBuffer(text.toString());
    }

    public String toString() {
        return this.text.toString();
    }

    public TextEditor replaceAll(String regex, String replacement) {
        if (this.text.length() > 0) {
            String r = replacement;
            Pattern p = Pattern.compile(regex, 8);
            Matcher m = p.matcher(this.text);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                m.appendReplacement(sb, r);
            }
            m.appendTail(sb);
            this.text = sb;
        }
        return this;
    }

    public TextEditor replaceAllLiteral(String regex, final String replacement) {
        return this.replaceAll(Pattern.compile(regex, 8), new Replacement(){

            @Override
            public String replacement(Matcher m) {
                return replacement;
            }
        });
    }

    public TextEditor replaceAll(Pattern pattern, Replacement replacement) {
        Matcher m = pattern.matcher(this.text);
        int lastIndex = 0;
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            sb.append(this.text.subSequence(lastIndex, m.start()));
            sb.append(replacement.replacement(m));
            lastIndex = m.end();
        }
        sb.append(this.text.subSequence(lastIndex, this.text.length()));
        this.text = sb;
        return this;
    }

    public TextEditor deleteAll(String pattern) {
        return this.replaceAll(pattern, "");
    }

    public TextEditor detabify() {
        return this.detabify(4);
    }

    public TextEditor detabify(final int tabWidth) {
        this.replaceAll(Pattern.compile("(.*?)\\t"), new Replacement(){

            @Override
            public String replacement(Matcher m) {
                String lineSoFar = m.group(1);
                int width = lineSoFar.length();
                StringBuffer replacement = new StringBuffer(lineSoFar);
                do {
                    replacement.append(' ');
                } while (++width % tabWidth != 0);
                return replacement.toString();
            }
        });
        return this;
    }

    public TextEditor outdent(int spaces) {
        return this.deleteAll("^(\\t|[ ]{1," + spaces + "})");
    }

    public TextEditor outdent() {
        return this.outdent(4);
    }

    public TextEditor trim() {
        this.text = new StringBuffer(this.text.toString().trim());
        return this;
    }

    public TextEditor indent(int spaces) {
        StringBuffer sb = new StringBuffer(spaces);
        for (int i = 0; i < spaces; ++i) {
            sb.append(' ');
        }
        return this.replaceAll("^", sb.toString());
    }

    public void append(CharSequence s) {
        this.text.append(s);
    }

    public Collection<HTMLToken> tokenizeHTML() {
        ArrayList<HTMLToken> tokens = new ArrayList<HTMLToken>();
        String nestedTags = this.nestedTagsRegex(6);
        Pattern p = Pattern.compile("(?s:<!(--.*?--\\s*)+>)|(?s:<\\?.*?\\?>)|" + nestedTags + "", 2);
        Matcher m = p.matcher(this.text);
        int lastPos = 0;
        while (m.find()) {
            if (lastPos < m.start()) {
                tokens.add(HTMLToken.text(this.text.substring(lastPos, m.start())));
            }
            tokens.add(HTMLToken.tag(this.text.substring(m.start(), m.end())));
            lastPos = m.end();
        }
        if (lastPos < this.text.length()) {
            tokens.add(HTMLToken.text(this.text.substring(lastPos, this.text.length())));
        }
        return tokens;
    }

    private String nestedTagsRegex(int depth) {
        if (depth == 0) {
            return "";
        }
        return "(?:<[a-z/!$](?:[^<>]|" + this.nestedTagsRegex(depth - 1) + ")*>)";
    }

    public void prepend(CharSequence s) {
        StringBuffer newText = new StringBuffer();
        newText.append(s);
        newText.append(this.text);
        this.text = newText;
    }

    public boolean isEmpty() {
        return this.text.length() == 0;
    }
}

