/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.dynamic.api.helper;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public final class Classes {
    private Classes() {
    }

    public static List<Class<?>> allSuperClasses(Class<?> clazz) {
        LinkedList allSuperClasses = new LinkedList();
        for (Class<?> superClass = clazz.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            allSuperClasses.add(superClass);
        }
        return allSuperClasses;
    }

    public static List<Field> allDeclaredFields(Class<?> clazz) {
        LinkedList<Field> allDeclaredFields = new LinkedList<Field>();
        for (Class<?> superClazz : Classes.allSuperClasses(clazz)) {
            allDeclaredFields.addAll(Arrays.asList(superClazz.getDeclaredFields()));
        }
        return allDeclaredFields;
    }

    public static Class<?> loadClass(ClassLoader classLoader, String name) {
        try {
            return classLoader.loadClass(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T newInstance(Class<?> clazz) {
        try {
            return (T)clazz.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String methodNameToDashBased(Method method) {
        String methodName = method.getName();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < methodName.length(); ++i) {
            char character = methodName.charAt(i);
            if (Character.isUpperCase(character)) {
                builder.append("-").append(Character.toLowerCase(character));
                continue;
            }
            builder.append(character);
        }
        return builder.toString();
    }

    public static <T extends Annotation> T getDeclaredAnnotation(Class<?> clazz, Class<T> annotationClass) {
        for (Class<?> superClass : Classes.allSuperClasses(clazz)) {
            T annotation = superClass.getAnnotation(annotationClass);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }
}

