/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.dynamic.api.helper;

import java.lang.reflect.Field;
import java.util.Map;
import org.mule.util.StringUtils;

public final class Reflections {
    private Reflections() {
    }

    public static Field setAccessible(Object object, String propertyName) {
        try {
            Field field = object.getClass().getDeclaredField(propertyName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Failed to make <" + propertyName + "> accessible", e);
        }
    }

    public static String getterMethodName(String propertyName) {
        return "get" + StringUtils.capitalize((String)propertyName);
    }

    public static Object get(Object object, String propertyName) {
        try {
            return Reflections.invoke(object, Reflections.getterMethodName(propertyName), Void.TYPE);
        }
        catch (RuntimeException e) {
            Field field = Reflections.setAccessible(object, propertyName);
            try {
                return field.get(object);
            }
            catch (IllegalAccessException ee) {
                throw new RuntimeException(ee);
            }
        }
    }

    public static String setterMethodName(String propertyName) {
        return "set" + StringUtils.capitalize((String)propertyName);
    }

    public static void set(Object object, String propertyName, Object value) {
        try {
            Reflections.invoke(object, Reflections.setterMethodName(propertyName), value);
        }
        catch (RuntimeException e) {
            Field field = Reflections.setAccessible(object, propertyName);
            try {
                field.set(object, value);
            }
            catch (IllegalAccessException ee) {
                throw new RuntimeException(ee);
            }
        }
    }

    public static void set(Object object, Map<String, Object> parameters) {
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String parameterName = entry.getKey();
            try {
                Reflections.invoke(object, Reflections.setterMethodName(parameterName), entry.getValue(), Object.class);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to set parameter <" + parameterName + ">", e);
            }
        }
    }

    public static Class<?> toPrimitive(Class<?> type) {
        if (type.equals(Integer.class)) {
            return Integer.TYPE;
        }
        if (type.equals(Float.class)) {
            return Float.TYPE;
        }
        if (type.equals(Long.class)) {
            return Long.TYPE;
        }
        if (type.equals(Double.class)) {
            return Double.TYPE;
        }
        if (type.equals(Character.class)) {
            return Character.TYPE;
        }
        if (type.equals(Byte.class)) {
            return Byte.TYPE;
        }
        if (type.equals(Short.class)) {
            return Short.TYPE;
        }
        if (type.equals(Boolean.class)) {
            return Boolean.TYPE;
        }
        throw new IllegalArgumentException("Unrecognized primitive type <" + type + ">");
    }

    public static Class<?> toType(Class<?> type) {
        if (type.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (type.equals(Float.TYPE)) {
            return Float.class;
        }
        if (type.equals(Long.TYPE)) {
            return Long.class;
        }
        if (type.equals(Double.TYPE)) {
            return Double.class;
        }
        if (type.equals(Character.TYPE)) {
            return Character.class;
        }
        if (type.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (type.equals(Short.TYPE)) {
            return Short.class;
        }
        if (type.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        throw new IllegalArgumentException("Unrecognized primitive type <" + type + ">");
    }

    public static Class<?> asType(Class<?> type) {
        if (type.isPrimitive()) {
            return Reflections.toType(type);
        }
        return type;
    }

    public static <T> T invoke(Object object, String method, Object argument) {
        try {
            return Reflections.invoke(object, method, argument, argument.getClass());
        }
        catch (RuntimeException e) {
            if (!argument.getClass().isPrimitive()) {
                throw e;
            }
            return Reflections.invoke(object, method, argument, Reflections.toPrimitive(argument.getClass()));
        }
    }

    public static <T> T invoke(Object object, String method, Object argument, Class<?> argumentType) {
        try {
            return (T)object.getClass().getMethod(method, argumentType).invoke(object, argument);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to invoke <" + method + "> with arguments <" + argument + "> on <" + object + ">", e);
        }
    }

    public static <T> T invoke(Object object, String method) {
        try {
            return (T)object.getClass().getMethod(method, new Class[0]).invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to invoke <" + method + "> on <" + object + ">", e);
        }
    }
}

