/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.dynamic.api.loader;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.Module;
import org.mule.devkit.dynamic.api.helper.Capabilities;
import org.mule.devkit.dynamic.api.helper.Capability;
import org.mule.devkit.dynamic.api.helper.Classes;
import org.mule.devkit.dynamic.api.helper.ConnectionManager;
import org.mule.devkit.dynamic.api.helper.Jars;
import org.mule.devkit.dynamic.api.loader.Loader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarLoader
extends Loader {
    private static final Logger LOGGER = Logger.getLogger(JarLoader.class.getPackage().getName());
    private static final String MODULE_CLASS_SUFFIX = "Module";
    private static final String CONNECTOR_CLASS_SUFFIX = "Connector";
    private static final String CONNECTION_MANAGER_CLASS_SUFFIX = "ConnectionManager";

    protected final List<String> findPotentialModuleClassNames(List<String> fileNames) {
        LinkedList<String> potentialModuleClassNames = new LinkedList<String>();
        for (String fileName : fileNames) {
            if (!fileName.endsWith("Module.class") && !fileName.endsWith("Connector.class")) continue;
            potentialModuleClassNames.add(fileName);
        }
        return potentialModuleClassNames;
    }

    protected final Class<?> findModuleClass(List<String> fileNames, ClassLoader classLoader) {
        List<String> potentialModuleClassNames = this.findPotentialModuleClassNames(fileNames);
        if (potentialModuleClassNames.isEmpty()) {
            throw new IllegalArgumentException("Failed to find potential Module class among <" + fileNames + ">");
        }
        for (String potentialModuleClassName : potentialModuleClassNames) {
            String className = this.extractClassName(potentialModuleClassName);
            Class<?> moduleClass = Classes.loadClass(classLoader, className);
            if (moduleClass == null) {
                throw new IllegalArgumentException("Failed to load <" + className + ">");
            }
            if (moduleClass.getAnnotation(Module.class) == null && moduleClass.getAnnotation(Connector.class) == null) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, "Skipping invalid module <{0}>", className);
                continue;
            }
            return moduleClass;
        }
        return null;
    }

    protected final Class<?> findMostSpecificSubClass(List<Class<?>> moduleSubClasses) {
        return Collections.max(moduleSubClasses, new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> class1, Class<?> class2) {
                return Integer.valueOf(Classes.allSuperClasses(class1).size()).compareTo(Classes.allSuperClasses(class2).size());
            }
        });
    }

    protected final ConnectionManager<?, ?> loadConnectionManager(String generatedPackageName, String moduleName, Capabilities capabilities, ClassLoader classLoader) {
        if (capabilities.isCapableOf(Capability.CONNECTION_MANAGEMENT_CAPABLE)) {
            String connectionManagerClassName = generatedPackageName + "." + moduleName + CONNECTION_MANAGER_CLASS_SUFFIX;
            Class<?> connectionManagerClass = Classes.loadClass(classLoader, connectionManagerClassName);
            if (connectionManagerClass == null) {
                throw new IllegalArgumentException("Failed to load ConnectionManager class <" + connectionManagerClassName + ">");
            }
            ConnectionManager connectionManager = (ConnectionManager)Classes.newInstance(connectionManagerClass);
            if (connectionManager == null) {
                throw new IllegalArgumentException("Failed to instantiate ConnectionManager class <" + connectionManagerClass.getCanonicalName() + ">");
            }
            return connectionManager;
        }
        return null;
    }

    protected final List<Class<?>> findModuleSubClasses(Class<?> moduleClass, List<String> fileNames, URLClassLoader classLoader) {
        String moduleClassSimpleName = moduleClass.getSimpleName();
        LinkedList subClasses = new LinkedList();
        for (String fileName : fileNames) {
            Class<?> clazz;
            if (!fileName.contains(moduleClassSimpleName) || !Classes.allSuperClasses(clazz = Classes.loadClass(classLoader, this.extractClassName(fileName))).contains(moduleClass)) continue;
            subClasses.add(clazz);
        }
        return subClasses;
    }

    public final org.mule.devkit.dynamic.api.model.Module load(List<URL> urls) throws IOException {
        URLClassLoader classLoader;
        URL moduleJar = urls.get(0);
        List<String> allFileNames = Jars.allFileNames(moduleJar);
        Class<?> moduleClass = this.findModuleClass(allFileNames, classLoader = new URLClassLoader(urls.toArray(new URL[urls.size()])));
        if (moduleClass == null) {
            throw new IllegalArgumentException("Failed to find Module class in <" + moduleJar + ">");
        }
        List<Class<?>> moduleSubClasses = this.findModuleSubClasses(moduleClass, allFileNames, classLoader);
        Class<?> mostSpecificSubClass = this.findMostSpecificSubClass(moduleSubClasses);
        Capabilities module = (Capabilities)Classes.newInstance(mostSpecificSubClass);
        if (module == null) {
            throw new IllegalArgumentException("Failed to instantiate Module class <" + moduleClass.getSimpleName() + ">");
        }
        if (module.isCapableOf(Capability.CONNECTION_MANAGEMENT_CAPABLE)) {
            return this.load(module, this.loadConnectionManager(mostSpecificSubClass.getPackage().getName(), moduleClass.getSimpleName(), module, classLoader));
        }
        return this.load(module, null);
    }
}

