/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.dynamic.api.invocation;

import java.util.Map;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.devkit.dynamic.api.helper.LifeCycles;
import org.mule.devkit.dynamic.api.helper.MuleEvents;
import org.mule.devkit.dynamic.api.helper.Reflections;

public class Invoker
implements Disposable {
    private final MuleContext context;
    private final MessageProcessor messageProcessor;
    private final int retryMax;
    private static final String RETRY_MAX_FIELD_NAME = "retryMax";

    public Invoker(MuleContext context, MessageProcessor messageProcessor, int retryMax) {
        if (context == null) {
            throw new IllegalArgumentException("null context");
        }
        if (messageProcessor == null) {
            throw new IllegalArgumentException("null messageProcessor");
        }
        this.context = context;
        this.messageProcessor = messageProcessor;
        this.retryMax = retryMax;
        try {
            this.initialise();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void initialise() throws InitialisationException, MuleException {
        Reflections.set(this.messageProcessor, RETRY_MAX_FIELD_NAME, this.retryMax);
        ((MuleContextAware)MuleContextAware.class.cast(this.messageProcessor)).setMuleContext(this.context);
        LifeCycles.initialise(this.messageProcessor);
        LifeCycles.start(this.messageProcessor);
    }

    public final <T> T invoke(Map<String, Object> processorParameters) throws MuleException {
        if (processorParameters == null) {
            throw new IllegalArgumentException("null processorParameters");
        }
        Reflections.set(this.messageProcessor, processorParameters);
        MuleEvent muleEvent = MuleEvents.defaultMuleEvent(processorParameters, this.context);
        return (T)this.messageProcessor.process(muleEvent).getMessage().getPayload();
    }

    public final void dispose() {
        try {
            LifeCycles.stop(this.messageProcessor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LifeCycles.dispose(this.messageProcessor);
    }
}

