/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.dynamic.api.invocation;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.retry.RetryCallback;
import org.mule.api.retry.RetryContext;
import org.mule.devkit.dynamic.api.invocation.DynamicModule;
import org.mule.devkit.dynamic.api.model.Module;
import org.mule.retry.policies.AbstractPolicyTemplate;

public class RetryingDynamicModule
extends DynamicModule {
    private final AbstractPolicyTemplate retryPolicyTemplate;

    public RetryingDynamicModule(Module module, Map<String, Object> overriddenParameters, AbstractPolicyTemplate retryPolicyTemplate) {
        this(module, overriddenParameters, 5, retryPolicyTemplate);
    }

    public RetryingDynamicModule(Module module, Map<String, Object> overriddenParameters, int retryMax, AbstractPolicyTemplate retryPolicyTemplate) {
        super(module, overriddenParameters, retryMax);
        if (retryPolicyTemplate == null) {
            throw new IllegalArgumentException("null retryPolicyTemplate");
        }
        retryPolicyTemplate.setMuleContext(this.getMuleContext());
        this.retryPolicyTemplate = retryPolicyTemplate;
    }

    @Override
    protected <T> T invoke(final MessageProcessor messageProcessor, final Map<String, Object> parameters) throws InitialisationException, MuleException {
        this.getInvoker(messageProcessor);
        try {
            final AtomicReference result = new AtomicReference();
            RetryContext retryContext = this.retryPolicyTemplate.execute(new RetryCallback(){

                public void doWork(RetryContext context) throws Exception {
                    result.set(RetryingDynamicModule.access$001(RetryingDynamicModule.this, messageProcessor, parameters));
                }

                public String getWorkDescription() {
                    return "RetryingDynamicModule";
                }
            }, null);
            if (!retryContext.isOk()) {
                throw new RuntimeException(retryContext.getLastFailure());
            }
            return (T)result.get();
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (MuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static /* synthetic */ Object access$001(RetryingDynamicModule x0, MessageProcessor x1, Map x2) throws InitialisationException, MuleException {
        return super.invoke(x1, (Map<String, Object>)x2);
    }
}

