/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.dynamic.browsing;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.mule.devkit.dynamic.api.helper.Reflections;
import org.sonatype.nexus.client.NexusClient;
import org.sonatype.nexus.client.NexusClientException;
import org.sonatype.nexus.client.NexusConnectionException;
import org.sonatype.nexus.client.rest.NexusRestClient;
import org.sonatype.nexus.rest.model.NexusArtifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NexusBrowser {
    private final String nexusUrl;
    private static final String DEFAULT_NEXUS_URL = "https://repository.mulesoft.org/nexus/";
    private static final String DEFAULT_GROUPD_ID = "org.mule.modules";
    private static final String DEFAULT_PACKAGING = "mule-module";
    private static final String CLIENT_HELPER_FIELD_NAME = "clientHelper";
    private static final String CHALLENGE_FIELD_NAME = "challenge";

    public NexusBrowser() {
        this(DEFAULT_NEXUS_URL);
    }

    public NexusBrowser(String nexusUrl) {
        this.nexusUrl = nexusUrl;
    }

    protected final NexusClient createConnectedClient(String url) throws NexusClientException, NexusConnectionException {
        NexusRestClient client = new NexusRestClient();
        client.connect(url, null, null);
        Reflections.set((Object)Reflections.get((Object)client, (String)CLIENT_HELPER_FIELD_NAME), (String)CHALLENGE_FIELD_NAME, null);
        return client;
    }

    protected final List<NexusArtifact> getMatchingGroup(NexusArtifact artifact, List<List<NexusArtifact>> allGroups) {
        List<Object> matchingGroup = null;
        for (List<NexusArtifact> group : allGroups) {
            NexusArtifact template = group.get(0);
            if (!template.getArtifactId().equals(artifact.getArtifactId()) || !template.getGroupId().equals(template.getGroupId())) continue;
            matchingGroup = group;
            break;
        }
        if (matchingGroup == null) {
            matchingGroup = new LinkedList();
            allGroups.add(matchingGroup);
        }
        return matchingGroup;
    }

    public final Set<String> listArtifactIds() throws Exception {
        return this.listArtifactIds(DEFAULT_GROUPD_ID, DEFAULT_PACKAGING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<String> listArtifactIds(String groupId, String packaging) throws NexusClientException, NexusConnectionException {
        NexusArtifact template = new NexusArtifact();
        template.setGroupId(groupId);
        template.setPackaging(packaging);
        HashSet<String> allArtifactIds = new HashSet<String>();
        NexusClient client = this.createConnectedClient(this.nexusUrl);
        try {
            List artifacts = client.searchByGAV(template);
            for (NexusArtifact artifact : artifacts) {
                allArtifactIds.add(artifact.getArtifactId());
            }
            HashSet<String> hashSet = allArtifactIds;
            return hashSet;
        }
        finally {
            client.disconnect();
        }
    }

    public final List<List<NexusArtifact>> listArtifacts() throws NexusClientException, NexusConnectionException {
        return this.listArtifacts(DEFAULT_GROUPD_ID, DEFAULT_PACKAGING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<List<NexusArtifact>> listArtifacts(String groupId, String packaging) throws NexusClientException, NexusConnectionException {
        NexusArtifact template = new NexusArtifact();
        template.setGroupId(groupId);
        template.setPackaging(packaging);
        LinkedList<List<NexusArtifact>> allGroups = new LinkedList<List<NexusArtifact>>();
        NexusClient client = this.createConnectedClient(this.nexusUrl);
        try {
            List artifacts = client.searchByGAV(template);
            for (NexusArtifact artifact : artifacts) {
                List<NexusArtifact> group = this.getMatchingGroup(artifact, allGroups);
                group.add(artifact);
            }
            LinkedList<List<NexusArtifact>> linkedList = allGroups;
            return linkedList;
        }
        finally {
            client.disconnect();
        }
    }

    public final Set<String> listArtifactVersions(String artifactId) throws Exception {
        return this.listArtifactVersions(DEFAULT_GROUPD_ID, artifactId, DEFAULT_PACKAGING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<String> listArtifactVersions(String groupId, String artifactId, String packaging) throws NexusClientException, NexusConnectionException {
        NexusArtifact template = new NexusArtifact();
        template.setGroupId(groupId);
        template.setArtifactId(artifactId);
        template.setPackaging(packaging);
        HashSet<String> versions = new HashSet<String>();
        NexusClient client = this.createConnectedClient(this.nexusUrl);
        try {
            List artifacts = client.searchByGAV(template);
            for (NexusArtifact artifact : artifacts) {
                versions.add(artifact.getVersion());
            }
            HashSet<String> hashSet = versions;
            return hashSet;
        }
        finally {
            client.disconnect();
        }
    }
}

