/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */

package org.mule.devkit.generation.api;

import java.util.List;

/**
 * Plugin that works on the generated source code.
 * <p/>
 * This plugin will be called after the default code generation
 * has finished.
 */
public interface Plugin {
    /**
     * Gets the option name to turn on this plugin-in.
     * <p/>
     * For example, if "abc" is returned, "-abc" will
     * turn on this plugin. If null is returned then the
     * plugin is turn on implicitly.
     */
    String getOptionName();

    /**
     * Retrieve a list of verifiers for the specified object type
     *
     * @return A list of verifiers implementing Verifier
     */
    public abstract List<? extends Verifier> getVerifiers();

    /**
     * Retrieve a list of generators for the specified object type
     *
     * @return A list of generators implementing ModuleGenerator
     */
    public abstract List<Generator> getGenerators();

    /**
     * Retrieve a list of post processors for the specified object type
     *
     * @return A list of post processors implementing {@link PostProcessor}
     */
    public abstract List<PostProcessor> getPostProcessors();
}
