/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */


package org.mule.devkit.generation.api;

import org.mule.devkit.model.Identifiable;
import org.mule.devkit.model.code.CodeModel;
import org.mule.devkit.model.schema.SchemaModel;
import org.mule.devkit.model.studio.StudioModel;

import java.util.List;

public interface Context {
    CodeModel getCodeModel();

    SchemaModel getSchemaModel();

    StudioModel getStudioModel();

    Manifest getManifest();

    void note(String msg);

    void warn(String msg);

    void error(String msg);

    void debug(String msg);

    void error(String msg, Identifiable element);

    <T> T getProduct(Product product);

    <T> T getProduct(Product product, Identifiable identifiable);

    <T> T getProduct(Product product, Identifiable identifiable, String methodName);

    <T> void registerProduct(Product product, T clazz);

    <T> void registerProduct(Product product, Identifiable identifiable, T clazz);

    <T> void registerProduct(Product product, Identifiable identifiable, String methodName, T clazz);

    <T> List<T> getProductList(Product product);

    <T> List<T> getModulesByProduct(Product product);

    MavenInformation getMavenInformation();
}
