package org.mule.devkit.generation.api.gatherer;

import org.apache.commons.lang.StringUtils;
import org.mule.devkit.model.Identifiable;

/**
 * Class that contains the details of the error and hints.
 */
public class Details {

    private String message;
    private Identifiable element;
    private String hint;

    public Details() {
        this.hint = null;
        this.message = null;
        this.element = null;
    }

    public Details(String message, Identifiable element) {
        this(message, element, null);
    }

    public Details(String message, Identifiable element,String hint) {
        this.hint = hint;
        this.setMessage(message);
        this.element = element;
    }

    /**
     * Given any non-null string, it will return a trimmed one, with the first letter capitalized, and with a final dot.
     *
     * @param message the message to be improved (if needed)
     * @return a formatted message
     */
    private String formatMessage(String message){
        if (StringUtils.isEmpty(message) ){
            return message;
        }
        String formattedMessage = StringUtils.trim(message);
        formattedMessage = StringUtils.capitalize(formattedMessage);
        //adding a last dot if not existed
        formattedMessage+= (formattedMessage.substring(formattedMessage.length() - 1).equals("."))?"":".";
        return formattedMessage;
    }


    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = formatMessage(message);
    }

    public Identifiable getElement() {
        return element;
    }

    public void setElement(Identifiable element) {
        this.element = element;
    }

    public String getHint() {
        return hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof Details)) return false;

        Details details = (Details) o;

        if (element != null ? !element.equals(details.element) : details.element != null) return false;
        if (hint != null ? !hint.equals(details.hint) : details.hint != null) return false;
        if (message != null ? !message.equals(details.message) : details.message != null) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = message != null ? message.hashCode() : 0;
        result = 31 * result + (element != null ? element.hashCode() : 0);
        result = 31 * result + (hint != null ? hint.hashCode() : 0);
        return result;
    }
}
