/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */

package org.mule.devkit.generation.api.annotations;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * Annotation used in classes implementing the Plugin or Verifier interface  to
 * check that the required dependencies are met by the developers building
 * Modules or Cloud Connectors
 *
 * Usage: \@RequiresMavenDependencies({\@Dependency(groudId = "groupId",
 *              artifactId="artifactId", version="version"})
 *
 * Example:
 * \@RequiresMavenDependencies({\@Dependency(groudId = "org.junit",
 *              artifactId="junit", version="4.8.3", scope="test"})
 * public class MyClass implements Plugin {
 *
 * \@RequiresMavenDependencies({\@Dependency(groudId = "oauth.signpost",
 *              artifactId = "signpost-core", version = "1.2.1.2"})
 * public class MyClass implements Verifier {
 *
 */
@Retention(value = RetentionPolicy.RUNTIME)
public @interface RequiresMavenDependencies {
    Dependency [] value();
}