/**
 * Mule Development Kit
 * Copyright 2010-2012 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * This software is protected under international copyright law. All use of this software is
 * subject to MuleSoft's Master Subscription Agreement (or other master license agreement)
 * separately entered into in writing between you and MuleSoft. If such an agreement is not
 * in place, you may not use the software.
 */



package org.mule.devkit.generation.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

import org.apache.commons.io.IOUtils;

public class SerializationUtils {

    public static <T> T load(File serializedObjectPath) {
        if (!serializedObjectPath.exists()) {
            throw new RuntimeException(String.format("File [%s] not found", serializedObjectPath.getAbsolutePath()));
        }

        T serializedObject = null;
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new FileInputStream(serializedObjectPath));
            serializedObject = (T) objectInputStream.readObject();
        } catch (IOException e) {
            throw new RuntimeException(e);
        } catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        } finally {
            IOUtils.closeQuietly(objectInputStream);
        }

        return serializedObject;
    }

    public static <T> void save(File serializedObjectPath, T object) {
        ObjectOutputStream objectOutputStream = null;
        OutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(serializedObjectPath);
            save(outputStream, object);
        } catch (FileNotFoundException e) {
            throw new RuntimeException(String.format("Could not create license descriptor file: [%s] ",
                    serializedObjectPath.getAbsolutePath()) + e.getMessage(), e);
        }

    }

    public static <T> void save(OutputStream outputStream, T object) {

        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
        } catch (IOException e) {
            throw new RuntimeException("Error serializing object", e);
        } finally {
            org.mule.util.IOUtils.closeQuietly(objectOutputStream);
        }
    }
}
