package org.mule.devkit.generation.api.gatherer;

import org.mule.devkit.model.Identifiable;

import java.util.List;

/**
 * Interface for the Notification Gatherer
 */
public interface NotificationGatherer {

    List<Notification> getErrors();
    List<Notification> getWarnings();
    List<Notification> getNotes();
    List<Notification> getNotifications();

    boolean hasErrors();
    boolean hasWarnings();
    boolean hasNotes();
    boolean hasNotifications();


    void error(Identifiable element, DevkitNotification error,Object... args);
    void errorAll(List<? extends Identifiable> elements, DevkitNotification error,Object... args);


    void warn(Identifiable element, DevkitNotification error,Object... args);
    void warnAll(List<? extends Identifiable> elements, DevkitNotification error,Object... args);


    void note(Identifiable element, DevkitNotification error,Object... args);
    void noteAll(List<? extends Identifiable> elements, DevkitNotification error,Object... args);
}
