/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.api;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.mule.devkit.generation.api.Plugin;

public class PluginScanner {
    private List<Plugin> allPlugins;
    private static PluginScanner INSTANCE = new PluginScanner();

    protected PluginScanner() {
    }

    public static PluginScanner getInstance() {
        return INSTANCE;
    }

    public List<Plugin> getAllPlugins(ClassLoader ucl) throws MalformedURLException {
        if (this.allPlugins == null) {
            this.allPlugins = new ArrayList<Plugin>();
            for (Plugin aug : PluginScanner.findServices(Plugin.class, ucl)) {
                this.allPlugins.add(aug);
            }
        }
        return this.allPlugins;
    }

    private static <T> T[] findServices(Class<T> clazz, ClassLoader classLoader) {
        try {
            Class<?> serviceLoader = Class.forName("java.util.ServiceLoader");
            Iterable itr = (Iterable)serviceLoader.getMethod("load", Class.class, ClassLoader.class).invoke(null, clazz, classLoader);
            ArrayList r = new ArrayList();
            for (Object t : itr) {
                r.add(t);
            }
            return r.toArray((Object[])Array.newInstance(clazz, r.size()));
        }
        catch (ClassNotFoundException e) {
        }
        catch (IllegalAccessException e) {
            IllegalAccessError x = new IllegalAccessError();
            x.initCause(e);
            throw x;
        }
        catch (InvocationTargetException e) {
            Throwable x = e.getTargetException();
            if (x instanceof RuntimeException) {
                throw (RuntimeException)x;
            }
            if (x instanceof Error) {
                throw (Error)x;
            }
            throw new Error(x);
        }
        catch (NoSuchMethodException e) {
            NoSuchMethodError x = new NoSuchMethodError();
            x.initCause(e);
            throw x;
        }
        return null;
    }

    public static void setInstance(PluginScanner pluginScanner) {
        INSTANCE = pluginScanner;
    }
}

