/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.generation.api.gatherer.printing;

public class FileNotificationMessage implements Comparable<FileNotificationMessage> {

    private String file;
    private Integer line;
    private String message;

    public FileNotificationMessage(String file, Integer line, String message) {
        this.file = file;
        this.line = line;
        this.message = message;
    }

    @Override
    public int compareTo(FileNotificationMessage fileNotificationMessage) {
        int result = getFile().compareTo(fileNotificationMessage.getFile());
        if(result == 0){
            result = getLine().compareTo(fileNotificationMessage.getLine());
        }
        return result;
    }

    public String getFile() {
        return file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public Integer getLine() {
        return line;
    }

    public void setLine(Integer line) {
        this.line = line;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
