/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.generation.api;

import org.mule.devkit.model.Identifiable;

import javax.annotation.processing.Messager;

/**
 * Private interface to handle a {@link Messager}, where a different policy can be accordingly applied
 */
public interface DevkitMessager {
    Messager getMessager();

    void note(String msg);

    void warn(String msg);

    void error(String msg);

    void debug(String msg);

    void error(String msg, Identifiable element);

    void warn(String msg, Identifiable element);

    void note(String msg, Identifiable element);

    void printStack(Exception e);
}
