/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.devkit.generation.api.annotations;

import org.mule.devkit.generation.api.Scope;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * Annotation used to describe a single dependency:
 *
 * Examples:
 * \@Dependency(groupId = "org.mule.sample", artifactId="sample-artifact", version="[1.0]")
 * \@Dependency(groupId = "org.mule.sample", artifactId="sample-artifact2", version="[2.3.1]",
 *      scope=Scope.PROVIDED)
 * \@Dependency(groupId = "org.mule.sample", artifactId="sample-artifact", version="[3.0.0,4.0.0)")
 */
@Retention(value = RetentionPolicy.RUNTIME)
public @interface Dependency {
    String groupId();
    String artifactId();
    String version();
    Scope scope() default Scope.COMPILE;
}
