/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.generation.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.mule.util.IOUtils;

public class SerializationUtils {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T load(File serializedObjectPath) {
        if (!serializedObjectPath.exists()) {
            throw new RuntimeException(String.format("File [%s] not found", serializedObjectPath.getAbsolutePath()));
        }
        Object serializedObject = null;
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new FileInputStream(serializedObjectPath));
            serializedObject = objectInputStream.readObject();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
                catch (ClassNotFoundException e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                org.apache.commons.io.IOUtils.closeQuietly(objectInputStream);
                throw throwable;
            }
        }
        org.apache.commons.io.IOUtils.closeQuietly((InputStream)objectInputStream);
        return (T)serializedObject;
    }

    public static <T> void save(File serializedObjectPath, T object) {
        Object objectOutputStream = null;
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(serializedObjectPath);
            SerializationUtils.save(outputStream, object);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(String.format("Could not create license descriptor file: [%s] ", serializedObjectPath.getAbsolutePath()) + e.getMessage(), e);
        }
    }

    public static <T> void save(OutputStream outputStream, T object) {
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Error serializing object", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(objectOutputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)objectOutputStream);
    }
}

