/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.idea.module;

import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SourcePathsBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.mule.devkit.idea.module.MuleModuleBuilderHelper;
import org.mule.devkit.idea.module.MuleModuleWizardStep;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MuleModuleBuilder
extends ModuleBuilder
implements SourcePathsBuilder {
    private static final Icon ICON = IconLoader.getIcon((String)"/mule24.png");
    private MavenProject myAggregatorProject;
    private MavenProject myParentProject;
    private boolean myInheritGroupId;
    private boolean myInheritVersion;
    private MavenId myProjectId;
    private String myContentEntryPath;
    private String myModuleName;
    private String myModulePackage;

    public void setupRootModel(ModifiableRootModel rootModel) throws ConfigurationException {
        final Project project = rootModel.getProject();
        final VirtualFile root = this.createAndGetContentEntry();
        rootModel.addContentEntry(root);
        rootModel.inheritSdk();
        MavenUtil.runWhenInitialized((Project)project, (Runnable)new DumbAwareRunnable(){

            public void run() {
                new MuleModuleBuilderHelper(MuleModuleBuilder.this.myProjectId, MuleModuleBuilder.this.myAggregatorProject, MuleModuleBuilder.this.myParentProject, MuleModuleBuilder.this.myInheritGroupId, MuleModuleBuilder.this.myInheritVersion, MuleModuleBuilder.this.getArchetype(), MuleModuleBuilder.this.myModuleName, MuleModuleBuilder.this.myModulePackage, MuleModuleBuilder.this.getDescription()).configure(project, root, false);
            }
        });
    }

    private VirtualFile createAndGetContentEntry() {
        String path = FileUtil.toSystemIndependentName((String)this.getContentEntryPath());
        new File(path).mkdirs();
        return LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
    }

    public ModuleWizardStep[] createWizardSteps(WizardContext wizardContext, ModulesProvider modulesProvider) {
        return new ModuleWizardStep[]{new MuleModuleWizardStep(wizardContext.getProject(), this)};
    }

    public ModuleType getModuleType() {
        return StdModuleTypes.JAVA;
    }

    public List<Pair<String, String>> getSourcePaths() {
        return Collections.emptyList();
    }

    public void setSourcePaths(List<Pair<String, String>> pairs) {
    }

    public void addSourcePath(Pair<String, String> stringStringPair) {
    }

    public void setAggregatorProject(MavenProject project) {
        this.myAggregatorProject = project;
    }

    public MavenProject getAggregatorProject() {
        return this.myAggregatorProject;
    }

    public void setParentProject(MavenProject project) {
        this.myParentProject = project;
    }

    public MavenProject getParentProject() {
        return this.myParentProject;
    }

    public void setProjectId(MavenId id) {
        this.myProjectId = id;
    }

    public MavenId getProjectId() {
        return this.myProjectId;
    }

    public String getModuleName() {
        return this.myModuleName;
    }

    public void setModuleName(String myModuleName) {
        this.myModuleName = myModuleName;
    }

    public String getModulePackage() {
        return this.myModulePackage;
    }

    public void setModulePackage(String myModulePackage) {
        this.myModulePackage = myModulePackage;
    }

    public String getBuilderId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void setInheritedOptions(boolean groupId, boolean version) {
        this.myInheritGroupId = groupId;
        this.myInheritVersion = version;
    }

    public boolean isInheritGroupId() {
        return this.myInheritGroupId;
    }

    public boolean isInheritVersion() {
        return this.myInheritVersion;
    }

    @Nullable
    public String getContentEntryPath() {
        if (this.myContentEntryPath == null) {
            String directory = this.getModuleFileDirectory();
            if (directory == null) {
                return null;
            }
            new File(directory).mkdirs();
            return directory;
        }
        return this.myContentEntryPath;
    }

    public void setContentEntryPath(String moduleRootPath) {
        String path = this.acceptParameter(moduleRootPath);
        if (path != null) {
            try {
                this.myContentEntryPath = FileUtil.resolveShortWindowsName((String)path);
            }
            catch (IOException e) {
                this.myContentEntryPath = path;
            }
        } else {
            this.myContentEntryPath = null;
        }
        if (this.myContentEntryPath != null) {
            this.myContentEntryPath = this.myContentEntryPath.replace(File.separatorChar, '/');
        }
    }

    public MavenProject findPotentialParentProject(Project project) {
        if (!MavenProjectsManager.getInstance((Project)project).isMavenizedProject()) {
            return null;
        }
        File parentDir = new File(this.getContentEntryPath()).getParentFile();
        if (parentDir == null) {
            return null;
        }
        VirtualFile parentPom = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(parentDir, "pom.xml"));
        if (parentPom == null) {
            return null;
        }
        return MavenProjectsManager.getInstance((Project)project).findProject(parentPom);
    }

    public abstract String getSubName();

    public abstract MavenArchetype getArchetype();

    public abstract MavenId getDefaultProjectId();

    public String getName() {
        return "Mule " + this.getSubName();
    }

    public String getDescription() {
        return "Create a new Mule Module.";
    }

    public Icon getBigIcon() {
        return ICON;
    }

    public String getPresentableName() {
        return this.getName();
    }
}

