/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.idea;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.xml.XmlSchemaProvider;
import gnu.trove.THashMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleSchemaProvider
extends XmlSchemaProvider {
    private static final Logger LOG = Logger.getInstance((String)MuleSchemaProvider.class.getName());
    private static final Key<CachedValue<Map<String, XmlFile>>> SCHEMAS_BUNDLE_KEY = Key.create((String)"spring_schemas");

    public boolean isAvailable(@NotNull XmlFile file) {
        return true;
    }

    public XmlFile getSchema(@NotNull @NonNls String url, @Nullable Module module, @NotNull PsiFile baseFile) {
        if (module == null) {
            return null;
        }
        return this.getSupportedSchemasByUrl(module).get(url);
    }

    @NotNull
    public Map<String, XmlFile> getSupportedSchemasByUrl(@NotNull Module module) {
        return this.computeSchemas(module);
    }

    @NotNull
    private Map<String, XmlFile> computeSchemas(@NotNull Module module) {
        Project project = module.getProject();
        Map<String, String> schemaUrlsAndFileNames = this.getSchemasFromSpringSchemas(module.getProject());
        Map<String, VirtualFile> allSchemaFilesByFileName = this.getAllSchemaFilesInProjectAndDepsByFileName(module);
        Map<String, XmlFile> schemasByUrl = this.createSupportedSchemasByUrl(schemaUrlsAndFileNames, allSchemaFilesByFileName, project);
        return schemasByUrl;
    }

    private Map<String, String> getSchemasFromSpringSchemas(@NotNull Project project) {
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        for (VirtualFile virtualFile : projectRootManager.getContentRoots()) {
            VirtualFile springSchemas = virtualFile.findFileByRelativePath("target/generated-sources/mule/META-INF/spring.schemas");
            if (springSchemas == null) continue;
            try {
                String springSchemasContent = new String(springSchemas.contentsToByteArray());
                return this.parseSpringSchemas(springSchemasContent);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read spring.schemas file content", e);
            }
        }
        LOG.warn("Cannot find spring.schemas");
        return new HashMap<String, String>();
    }

    private Map<String, XmlFile> createSupportedSchemasByUrl(Map<String, String> supportedSchemas, Map<String, VirtualFile> allSchemaFilesByFileName, Project project) {
        THashMap schemasByUrl = new THashMap();
        for (Map.Entry<String, String> supportedSchema : supportedSchemas.entrySet()) {
            String fileName = supportedSchema.getValue();
            VirtualFile virtualFile = allSchemaFilesByFileName.get(fileName);
            if (virtualFile != null) {
                String url = supportedSchema.getKey();
                schemasByUrl.put(url, this.findOrCreateXmlFile(virtualFile, project));
                continue;
            }
            LOG.warn("Schema declared in spring.schemas but not available within project files or dependencies: " + supportedSchema);
        }
        return schemasByUrl;
    }

    private XmlFile findOrCreateXmlFile(VirtualFile virtualFile, Project project) {
        XmlFile xmlFile = this.findXmlFile(virtualFile, project);
        if (xmlFile != null) {
            return xmlFile;
        }
        return this.createXmlFile(virtualFile, project);
    }

    private XmlFile findXmlFile(VirtualFile virtualFile, Project project) {
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        if (psiFile != null) {
            try {
                return (XmlFile)psiFile.copy();
            }
            catch (Exception e) {
                LOG.warn("Error copying schema: " + virtualFile.getPath(), (Throwable)e);
            }
        }
        return null;
    }

    private XmlFile createXmlFile(VirtualFile virtualFile, Project project) {
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)project);
        try {
            return (XmlFile)psiFileFactory.createFileFromText(virtualFile.getName(), (FileType)StdFileTypes.XML, (CharSequence)new String(virtualFile.contentsToByteArray()));
        }
        catch (IOException e) {
            LOG.warn("Cannot read schema file: " + virtualFile.getPath());
            throw new RuntimeException(e);
        }
    }

    private Map<String, String> parseSpringSchemas(String springSchemasContent) {
        HashMap<String, String> schemaUrlsAndFileNames = new HashMap<String, String>();
        for (String line : springSchemasContent.split("\n")) {
            if (line.startsWith("#")) continue;
            String url = line.substring(0, line.indexOf("=")).replaceAll("\\\\", "");
            String fileName = line.substring(line.indexOf("="));
            if (fileName.contains("/")) {
                fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
            }
            schemaUrlsAndFileNames.put(url, fileName);
        }
        return schemaUrlsAndFileNames;
    }

    private Map<String, VirtualFile> getAllSchemaFilesInProjectAndDepsByFileName(Module module) {
        ProjectRootManager manager = ProjectRootManager.getInstance((Project)module.getProject());
        HashMap<String, VirtualFile> allSchemaFiles = new HashMap<String, VirtualFile>();
        for (VirtualFile virtualFile : manager.getContentRoots()) {
            allSchemaFiles.putAll(this.findAllSchemaFiles(virtualFile));
        }
        ModuleWithDependenciesScope scope = (ModuleWithDependenciesScope)module.getModuleWithDependenciesAndLibrariesScope(false);
        for (VirtualFile virtualFile : scope.getRoots()) {
            allSchemaFiles.putAll(this.findAllSchemaFiles(virtualFile));
        }
        return allSchemaFiles;
    }

    private Map<String, VirtualFile> findAllSchemaFiles(VirtualFile virtualFile) {
        VirtualFile[] entries;
        HashMap<String, VirtualFile> files = new HashMap<String, VirtualFile>();
        for (VirtualFile entry : entries = virtualFile.getChildren()) {
            if (entry.getName().endsWith(".xsd")) {
                files.put(entry.getName(), entry);
            }
            if (!entry.isDirectory()) continue;
            files.putAll(this.findAllSchemaFiles(entry));
        }
        return files;
    }
}

