/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.idea.compiler;

import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.GeneratingCompiler;
import com.intellij.openapi.compiler.SourceGeneratingCompiler;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.compiler.ex.CompileContextEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ArrayUtil;
import java.io.DataInput;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mule.devkit.idea.compiler.MuleApt;
import org.mule.devkit.idea.compiler.MuleAptGenerationItem;
import org.mule.devkit.idea.compiler.MuleAptPrepareAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleAptCompiler
implements SourceGeneratingCompiler {
    private static final GeneratingCompiler.GenerationItem[] EMPTY_GENERATION_ITEM_ARRAY = new GeneratingCompiler.GenerationItem[0];
    private static final Pattern ourMessagePattern = Pattern.compile("(.+):(\\d+):.+");

    public VirtualFile getPresentableFile(CompileContext compileContext, Module module, VirtualFile virtualFile, VirtualFile virtualFile1) {
        return null;
    }

    public GeneratingCompiler.GenerationItem[] getGenerationItems(CompileContext compileContext) {
        return (GeneratingCompiler.GenerationItem[])ApplicationManager.getApplication().runReadAction((Computable)new MuleAptPrepareAction(compileContext));
    }

    private static void addMessages(CompileContext context, Map<CompilerMessageCategory, List<String>> messages) {
        MuleAptCompiler.addMessages(context, messages, null);
    }

    @NotNull
    private static String getPresentableFile(@NotNull String url, @Nullable Map<VirtualFile, VirtualFile> presentableFilesMap) {
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
        if (file == null) {
            return url;
        }
        if (presentableFilesMap == null) {
            return url;
        }
        for (Map.Entry<VirtualFile, VirtualFile> entry : presentableFilesMap.entrySet()) {
            if (file != entry.getValue()) continue;
            return entry.getKey().getUrl();
        }
        return url;
    }

    private static void addMessages(final CompileContext context, final Map<CompilerMessageCategory, List<String>> messages, final @Nullable Map<VirtualFile, VirtualFile> presentableFilesMap) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            public void run() {
                if (context.getProject().isDisposed()) {
                    return;
                }
                for (CompilerMessageCategory category : messages.keySet()) {
                    List messageList = (List)messages.get(category);
                    for (String message : messageList) {
                        String fileName;
                        String url = null;
                        int line = -1;
                        Matcher matcher = ourMessagePattern.matcher(message);
                        if (matcher.matches() && new File(fileName = matcher.group(1)).exists()) {
                            url = MuleAptCompiler.getPresentableFile("file://" + fileName, presentableFilesMap);
                            line = Integer.parseInt(matcher.group(2));
                        }
                        context.addMessage(category, message, url, line, -1);
                    }
                }
            }
        });
    }

    private static GeneratingCompiler.GenerationItem[] doGenerate(final CompileContext context, GeneratingCompiler.GenerationItem[] items) {
        ArrayList<MuleAptGenerationItem> results = new ArrayList<MuleAptGenerationItem>(items.length);
        for (GeneratingCompiler.GenerationItem item : items) {
            MuleAptGenerationItem aptItem;
            if (!(item instanceof MuleAptGenerationItem) || !MuleAptCompiler.isModuleAffected(context, (aptItem = (MuleAptGenerationItem)item).getModule())) continue;
            try {
                Map<CompilerMessageCategory, List<String>> messages = MuleApt.compile(aptItem);
                MuleAptCompiler.addMessages(context, messages);
                if (!messages.get(CompilerMessageCategory.ERROR).isEmpty()) continue;
                results.add(aptItem);
            }
            catch (IOException e) {
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    public void run() {
                        if (context.getProject().isDisposed()) {
                            return;
                        }
                        context.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), null, -1, -1);
                    }
                });
            }
        }
        return results.toArray(new GeneratingCompiler.GenerationItem[results.size()]);
    }

    public static boolean isModuleAffected(CompileContext context, Module module) {
        return ArrayUtil.find((Object[])context.getCompileScope().getAffectedModules(), (Object)module) >= 0;
    }

    public GeneratingCompiler.GenerationItem[] generate(final CompileContext compileContext, final GeneratingCompiler.GenerationItem[] items, VirtualFile virtualFile) {
        if (items != null && items.length > 0) {
            compileContext.getProgressIndicator().setText("Generating Mule Code");
            Computable<GeneratingCompiler.GenerationItem[]> computation = new Computable<GeneratingCompiler.GenerationItem[]>(){

                public GeneratingCompiler.GenerationItem[] compute() {
                    if (compileContext.getProject().isDisposed()) {
                        return EMPTY_GENERATION_ITEM_ARRAY;
                    }
                    return MuleAptCompiler.doGenerate(compileContext, items);
                }
            };
            GeneratingCompiler.GenerationItem[] generationItems = (GeneratingCompiler.GenerationItem[])computation.compute();
            ArrayList<VirtualFile> generatedVFiles = new ArrayList<VirtualFile>();
            for (GeneratingCompiler.GenerationItem aptGenerationItem : generationItems) {
                ArrayList files = new ArrayList();
                CompilerUtil.collectFiles(files, (File)new File(aptGenerationItem.getModule().getModuleFile().getParent().getPath() + "/target/generated-sources"), (FileFilter)new FileFilter(){

                    public boolean accept(File file) {
                        return true;
                    }
                });
                CompilerUtil.refreshIOFiles(files);
                for (File file : files) {
                    VirtualFile generatedVFile = LocalFileSystem.getInstance().findFileByIoFile(file);
                    generatedVFiles.add(generatedVFile);
                }
            }
            if (compileContext instanceof CompileContextEx) {
                ((CompileContextEx)compileContext).markGenerated(generatedVFiles);
            }
            return generationItems;
        }
        return EMPTY_GENERATION_ITEM_ARRAY;
    }

    @NotNull
    public String getDescription() {
        return "Mule DevKit Code Generator";
    }

    public boolean validateConfiguration(CompileScope compileScope) {
        return true;
    }

    public ValidityState createValidityState(DataInput dataInput) throws IOException {
        return null;
    }
}

