/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.idea.compiler;

import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathsList;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.jetbrains.annotations.NotNull;
import org.mule.devkit.idea.compiler.MuleAptGenerationItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleApt {
    private MuleApt() {
    }

    private static void ensureDirectoryExists(String path) {
        File f = new File(path);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = MuleApt.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static Map<CompilerMessageCategory, List<String>> compile(@NotNull MuleAptGenerationItem aptGenerationItem) throws IOException {
        final HashMap<CompilerMessageCategory, List<String>> messages = new HashMap<CompilerMessageCategory, List<String>>();
        messages.put(CompilerMessageCategory.ERROR, new ArrayList());
        messages.put(CompilerMessageCategory.WARNING, new ArrayList());
        messages.put(CompilerMessageCategory.INFORMATION, new ArrayList());
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        ArrayList<File> files = new ArrayList<File>();
        files.add(new File(aptGenerationItem.muleModule.getPath()));
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(files);
        PathsList classPath = OrderEnumerator.orderEntries((Project)aptGenerationItem.getModule().getProject()).withoutModuleSourceEntries().getPathsList();
        for (String path : classPath.getPathList()) {
            if (!path.contains("mule-devkit-annotations")) continue;
            String newpath = null;
            newpath = path.replace("mule-devkit-annotations", "mule-devkit-annotations-processor");
            classPath.add(newpath);
            newpath = path.replace("mule-devkit-annotations", "mule-devkit-codemodel");
            classPath.add(newpath);
            newpath = path.replace("mule-devkit-annotations", "mule-devkit-schemamodel");
            classPath.add(newpath);
            newpath = path.replace("mule-devkit-annotations", "mule-devkit-studiomodel");
            classPath.add(newpath);
        }
        String compileClassPath = classPath.getPathsString();
        ArrayList<String> options = new ArrayList<String>(10);
        String modulePath = aptGenerationItem.getModule().getModuleFilePath();
        modulePath = modulePath.substring(0, modulePath.lastIndexOf("/"));
        String classesPath = modulePath + "/target/classes";
        String generatedSourcesPath = modulePath + "/target/generated-sources/mule";
        ArrayList filesToDelete = new ArrayList();
        CompilerUtil.collectFiles(filesToDelete, (File)new File(generatedSourcesPath), (FileFilter)new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getAbsolutePath().endsWith("java");
            }
        });
        for (File file : filesToDelete) {
            VirtualFile generatedVFile = LocalFileSystem.getInstance().findFileByIoFile(file);
            generatedVFile.delete(null);
        }
        MuleApt.ensureDirectoryExists(classesPath);
        MuleApt.ensureDirectoryExists(generatedSourcesPath);
        options.add("-cp");
        options.add(compileClassPath);
        options.add("-proc:only");
        options.add("-processor");
        options.add("org.mule.devkit.apt.ModuleAnnotationProcessor");
        options.add("-d");
        options.add(classesPath);
        options.add("-s");
        options.add(generatedSourcesPath);
        DiagnosticListener<JavaFileObject> dl = null;
        dl = new DiagnosticListener<JavaFileObject>(){

            @Override
            public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                if (diagnostic.getKind() == Diagnostic.Kind.ERROR) {
                    ((List)messages.get(CompilerMessageCategory.ERROR)).add(diagnostic.toString().replace("error: ", ""));
                } else if (diagnostic.getKind() == Diagnostic.Kind.WARNING) {
                    ((List)messages.get(CompilerMessageCategory.WARNING)).add(diagnostic.toString());
                } else {
                    ((List)messages.get(CompilerMessageCategory.INFORMATION)).add(diagnostic.toString());
                }
            }
        };
        JavaCompiler.CompilationTask task = compiler.getTask(new PrintWriter(System.out), fileManager, (DiagnosticListener<? super JavaFileObject>)dl, options, null, compilationUnits);
        if (!task.call().booleanValue() && ((List)messages.get(CompilerMessageCategory.ERROR)).isEmpty()) {
            ((List)messages.get(CompilerMessageCategory.ERROR)).add("An unknown error has occurred.");
        }
        VirtualFile generatedSourcesVFile = LocalFileSystem.getInstance().findFileByIoFile(new File(generatedSourcesPath));
        generatedSourcesVFile.refresh(false, true);
        return messages;
    }
}

