/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.idea.module;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.navigator.SelectMavenProjectDialog;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.mule.devkit.idea.module.MuleModuleBuilder;

public class MuleModuleWizardStep
extends ModuleWizardStep {
    private static final Icon WIZARD_ICON = IconLoader.getIcon((String)"/addmodulewizard.png");
    private static final String INHERIT_GROUP_ID_KEY = "MavenModuleWizard.inheritGroupId";
    private static final String INHERIT_VERSION_KEY = "MavenModuleWizard.inheritVersion";
    private final Project myProjectOrNull;
    private final MuleModuleBuilder myBuilder;
    private MavenProject myAggregator;
    private MavenProject myParent;
    private String myInheritedGroupId;
    private String myInheritedVersion;
    private JPanel myMainPanel;
    private JLabel myAggregatorLabel;
    private JLabel myAggregatorNameLabel;
    private JButton mySelectAggregator;
    private JLabel myParentLabel;
    private JLabel myParentNameLabel;
    private JButton mySelectParent;
    private JTextField myGroupIdField;
    private JCheckBox myInheritGroupIdCheckBox;
    private JTextField myArtifactIdField;
    private JTextField myVersionField;
    private JCheckBox myInheritVersionCheckBox;
    private JTextField myModuleName;
    private JTextField myModulePackage;

    public MuleModuleWizardStep(@Nullable Project project, MuleModuleBuilder builder) {
        this.myProjectOrNull = project;
        this.myBuilder = builder;
        this.initComponents();
        this.loadSettings();
    }

    private void initComponents() {
        this.mySelectAggregator.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MuleModuleWizardStep.this.myAggregator = MuleModuleWizardStep.this.doSelectProject(MuleModuleWizardStep.this.myAggregator);
                MuleModuleWizardStep.this.updateComponents();
            }
        });
        this.mySelectParent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MuleModuleWizardStep.this.myParent = MuleModuleWizardStep.this.doSelectProject(MuleModuleWizardStep.this.myParent);
                MuleModuleWizardStep.this.updateComponents();
            }
        });
        ActionListener updatingListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MuleModuleWizardStep.this.updateComponents();
            }
        };
        this.myInheritGroupIdCheckBox.addActionListener(updatingListener);
        this.myInheritVersionCheckBox.addActionListener(updatingListener);
        this.myModuleName.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
            }

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
                MuleModuleWizardStep.this.myArtifactIdField.setText("mule-module-" + MuleModuleWizardStep.this.myModuleName.getText().toLowerCase());
                MuleModuleWizardStep.this.myModulePackage.setText("org.mule.modules." + MuleModuleWizardStep.this.myModuleName.getText().toLowerCase());
            }
        });
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myGroupIdField;
    }

    private MavenProject doSelectProject(MavenProject current) {
        assert (this.myProjectOrNull != null) : "must not be called when creating a new project";
        SelectMavenProjectDialog d = new SelectMavenProjectDialog(this.myProjectOrNull, current);
        d.show();
        if (!d.isOK()) {
            return current;
        }
        return d.getResult();
    }

    public void onStepLeaving() {
        this.saveSettings();
    }

    public void disposeUIResources() {
        super.disposeUIResources();
    }

    private void loadSettings() {
        this.myBuilder.setInheritedOptions(this.getSavedValue(INHERIT_GROUP_ID_KEY, true), this.getSavedValue(INHERIT_VERSION_KEY, true));
    }

    private void saveSettings() {
        this.saveValue(INHERIT_GROUP_ID_KEY, this.myInheritGroupIdCheckBox.isSelected());
        this.saveValue(INHERIT_VERSION_KEY, this.myInheritVersionCheckBox.isSelected());
    }

    private boolean getSavedValue(String key, boolean defaultValue) {
        return this.getSavedValue(key, String.valueOf(defaultValue)).equals(String.valueOf(true));
    }

    private String getSavedValue(String key, String defaultValue) {
        String value = PropertiesComponent.getInstance().getValue(key);
        return value == null ? defaultValue : value;
    }

    private void saveValue(String key, boolean value) {
        this.saveValue(key, String.valueOf(value));
    }

    private void saveValue(String key, String value) {
        PropertiesComponent props = PropertiesComponent.getInstance();
        props.setValue(key, value);
    }

    public JComponent getComponent() {
        return this.myMainPanel;
    }

    public void updateStep() {
        if (this.isMavenizedProject()) {
            MavenProject parent;
            this.myAggregator = parent = this.myBuilder.findPotentialParentProject(this.myProjectOrNull);
            this.myParent = parent;
        }
        this.myArtifactIdField.setText(this.myBuilder.getDefaultProjectId().getArtifactId());
        this.myGroupIdField.setText(this.myParent == null ? this.myBuilder.getDefaultProjectId().getGroupId() : this.myParent.getMavenId().getGroupId());
        this.myVersionField.setText(this.myParent == null ? this.myBuilder.getDefaultProjectId().getVersion() : this.myParent.getMavenId().getVersion());
        this.myInheritGroupIdCheckBox.setSelected(this.myBuilder.isInheritGroupId());
        this.myInheritVersionCheckBox.setSelected(this.myBuilder.isInheritVersion());
        this.updateComponents();
    }

    private boolean isMavenizedProject() {
        return this.myProjectOrNull != null && MavenProjectsManager.getInstance((Project)this.myProjectOrNull).isMavenizedProject();
    }

    private void updateComponents() {
        if (!this.isMavenizedProject()) {
            this.myAggregatorLabel.setEnabled(false);
            this.myAggregatorNameLabel.setEnabled(false);
            this.mySelectAggregator.setEnabled(false);
            this.myParentLabel.setEnabled(false);
            this.myParentNameLabel.setEnabled(false);
            this.mySelectParent.setEnabled(false);
        }
        this.myAggregatorNameLabel.setText(this.formatProjectString(this.myAggregator));
        this.myParentNameLabel.setText(this.formatProjectString(this.myParent));
        if (this.myParent == null) {
            this.myGroupIdField.setEnabled(true);
            this.myVersionField.setEnabled(true);
            this.myInheritGroupIdCheckBox.setEnabled(false);
            this.myInheritVersionCheckBox.setEnabled(false);
        } else {
            this.myGroupIdField.setEnabled(!this.myInheritGroupIdCheckBox.isSelected());
            this.myVersionField.setEnabled(!this.myInheritVersionCheckBox.isSelected());
            if (this.myInheritGroupIdCheckBox.isSelected() || this.myGroupIdField.getText().equals(this.myInheritedGroupId)) {
                this.myGroupIdField.setText(this.myParent.getMavenId().getGroupId());
            }
            if (this.myInheritVersionCheckBox.isSelected() || this.myVersionField.getText().equals(this.myInheritedVersion)) {
                this.myVersionField.setText(this.myParent.getMavenId().getVersion());
            }
            this.myInheritedGroupId = this.myGroupIdField.getText();
            this.myInheritedVersion = this.myVersionField.getText();
            this.myInheritGroupIdCheckBox.setEnabled(true);
            this.myInheritVersionCheckBox.setEnabled(true);
        }
    }

    private String formatProjectString(MavenProject project) {
        if (project == null) {
            return "<none>";
        }
        return project.getMavenId().getDisplayString();
    }

    public void updateDataModel() {
        this.myBuilder.setAggregatorProject(this.myAggregator);
        this.myBuilder.setParentProject(this.myParent);
        this.myBuilder.setProjectId(new MavenId(this.myGroupIdField.getText(), this.myArtifactIdField.getText(), this.myVersionField.getText()));
        this.myBuilder.setInheritedOptions(this.myInheritGroupIdCheckBox.isSelected(), this.myInheritVersionCheckBox.isSelected());
        this.myBuilder.setModuleName(this.myModuleName.getText());
        this.myBuilder.setModulePackage(this.myModulePackage.getText());
    }

    public Icon getIcon() {
        return WIZARD_ICON;
    }

    public String getHelpId() {
        return "reference.dialogs.new.project.fromScratch.maven";
    }
}

