/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.core;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public class SignatureHandler {
    private static final String SHA_512_WITH_RSA = "SHA512withRSA";

    public static byte[] sign(InputStream data, PrivateKey privateKey, String algorithm) throws Exception {
        int len;
        Signature sigWriter = Signature.getInstance(algorithm);
        sigWriter.initSign(privateKey);
        BufferedInputStream bufin = new BufferedInputStream(data);
        byte[] buffer = new byte[1024];
        while ((len = bufin.read(buffer)) >= 0) {
            sigWriter.update(buffer, 0, len);
        }
        bufin.close();
        return sigWriter.sign();
    }

    public static boolean verify(String signatureFile, PublicKey publicKey, String dataFile) throws Exception {
        Signature signatureVerifier = Signature.getInstance(SHA_512_WITH_RSA);
        signatureVerifier.initVerify(publicKey);
        byte[] sigToVerify = SignatureHandler.loadSignature(signatureFile);
        SignatureHandler.loadDataToVerify(dataFile, signatureVerifier);
        return signatureVerifier.verify(sigToVerify);
    }

    public static byte[] loadSignature(String signatureFile) throws IOException {
        FileInputStream sigIS = new FileInputStream(signatureFile);
        byte[] sigToVerify = new byte[((InputStream)sigIS).available()];
        ((InputStream)sigIS).read(sigToVerify);
        ((InputStream)sigIS).close();
        return sigToVerify;
    }

    private static void loadDataToVerify(String dataFile, Signature signReader) throws IOException, SignatureException {
        FileInputStream dataIS = new FileInputStream(dataFile);
        byte[] buffer = new byte[1024];
        BufferedInputStream bufin = new BufferedInputStream(dataIS);
        while (bufin.available() != 0) {
            int len = bufin.read(buffer);
            signReader.update(buffer, 0, len);
        }
        bufin.close();
    }
}

