/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.mojo;

import java.io.FileInputStream;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.security.Key;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.tools.devkit.core.KeyHandler;

public abstract class AbstractSecurityMojo
extends AbstractMojo {
    @Parameter(required=true, property="keystore")
    protected String keystore;
    @Parameter(required=true, property="key.name")
    protected String alias;
    @Parameter(required=true, property="data")
    protected String data;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.validateFile(this.data);
        this.validateFile(this.keystore);
        if (StringUtils.isBlank((CharSequence)this.alias)) {
            throw new MojoExecutionException("[key.name] cannot be null or empty");
        }
    }

    protected Key getKey(boolean usePublic) throws Exception {
        char[] password = System.console().readPassword("* Enter keystore password: ", new Object[0]);
        if (usePublic) {
            return KeyHandler.loadPub(this.alias, new FileInputStream(this.keystore), password);
        }
        return KeyHandler.loadPrv(this.alias, new FileInputStream(this.keystore), password);
    }

    protected void validateFile(String path) throws MojoExecutionException {
        try {
            if (!Paths.get(path, new String[0]).toFile().exists()) {
                throw new MojoExecutionException("Invalid file: " + path);
            }
        }
        catch (InvalidPathException e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }
}

