/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.mojo;

import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.security.PrivateKey;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.mule.tools.devkit.core.KeyHandler;
import org.mule.tools.devkit.core.SignatureHandler;
import org.mule.tools.devkit.mojo.AbstractSecurityMojo;

@Mojo(name="sign", requiresProject=false)
public class FileSignerMojo
extends AbstractSecurityMojo {
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        try {
            Console console = System.console();
            char[] password = console.readPassword("Enter your keystore password: ", new Object[0]);
            PrivateKey privateKey = KeyHandler.loadPrv(this.alias, new FileInputStream(this.keystore), password);
            byte[] signedData = SignatureHandler.sign(new FileInputStream(this.data), privateKey, "SHA512withRSA");
            FileUtils.writeByteArrayToFile((File)new File(FilenameUtils.getName((String)this.data) + ".sig"), (byte[])signedData);
        }
        catch (Exception e) {
            throw new MojoFailureException("Failed to sign " + this.data + " with the keystore " + this.keystore);
        }
    }
}

