/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.mojo;

import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.tools.devkit.core.KeyHandler;

@Mojo(name="getpub", requiresProject=false)
public class GetPublicKeyMojo
extends AbstractMojo {
    @Parameter(required=true, property="keystore")
    private String keystore;
    @Parameter(required=true, property="key.name")
    private String alias;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (StringUtils.isBlank((CharSequence)this.keystore) || !Paths.get(this.keystore, new String[0]).toFile().exists()) {
            throw new MojoFailureException("Invalid keystore path :" + this.keystore);
        }
        if (StringUtils.isBlank((CharSequence)this.alias)) {
            throw new MojoExecutionException("[key.name] cannot be null or empty");
        }
        Console console = System.console();
        char[] password = console.readPassword("Enter your keystore password: ", new Object[0]);
        try {
            byte[] pubKey = KeyHandler.loadPub(this.alias, new FileInputStream(this.keystore), password).getEncoded();
            FileUtils.writeByteArrayToFile((File)Paths.get(this.alias.concat(".pub"), new String[0]).toFile(), (byte[])pubKey);
        }
        catch (Exception e) {
            throw new MojoFailureException("Failed to extract the public key from the given keystore");
        }
    }
}

