/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.mojo;

import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.tools.devkit.core.KeyHandler;

@Mojo(name="keygen", requiresProject=false)
public class KeyPairGenerationMojo
extends AbstractMojo {
    @Parameter(required=true, property="key.name")
    private String keyName;
    @Parameter(property="key.size", defaultValue="2048")
    private Integer keySize;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (StringUtils.isBlank((CharSequence)this.keyName)) {
            throw new MojoFailureException("Invalid key name: " + this.keyName);
        }
        if (this.keySize % 1024 != 0) {
            throw new MojoFailureException("Invalid algorithm key size: " + this.keySize + " must be multiple of 1024");
        }
        try {
            KeyHandler.generatePair(this.keyName + ".pub", this.keyName + ".prv", this.keySize);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }
}

