/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.mojo;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.tools.devkit.core.KeyHandler;
import org.mule.tools.devkit.core.SignatureHandler;
import org.mule.tools.devkit.core.ZippedBundle;
import org.mule.tools.devkit.template.LicenseInfoTemplate;

@Mojo(name="license", requiresProject=false)
public class LicenseGenerationMojo
extends AbstractMojo {
    @Parameter(required=false, property="vendor.keystore")
    private String keyStore;
    @Parameter(required=true, property="client")
    private String client;
    @Parameter(required=true, property="vendor")
    private String vendorName;
    @Parameter(required=true, property="feature")
    private String feature;
    @Parameter(required=true, property="lic.name")
    private String licenseName;
    @Parameter(required=false, property="days.to.expire")
    private String daysToExpiration;
    @Parameter(required=false, property="versions")
    private String validVersions;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.initialise();
        try {
            char[] password = System.console().readPassword("* Enter keystore password: ", new Object[0]);
            PrivateKey privateKey = KeyHandler.loadPrv(this.vendorName, new FileInputStream(this.keyStore), password);
            ZippedBundle bundle = new ZippedBundle(Paths.get(this.licenseName + ".lic", new String[0]).toString());
            byte[] license = new LicenseInfoTemplate(this.feature, this.vendorName, this.client, this.daysToExpiration, this.validVersions).build();
            bundle.addEntry(this.licenseName.concat(".info"), new ByteArrayInputStream(license));
            byte[] signedData = SignatureHandler.sign(new ByteArrayInputStream(license), privateKey, "SHA512withRSA");
            bundle.addEntry(this.licenseName.concat(".sig"), new ByteArrayInputStream(signedData));
            bundle.export();
        }
        catch (Exception e) {
            throw new MojoFailureException("Failed to create a license using the given keystore and data: " + e.getMessage());
        }
    }

    private void initialise() throws MojoFailureException {
        if (StringUtils.isBlank((CharSequence)this.client)) {
            throw new MojoFailureException("Invalid client name");
        }
        if (StringUtils.isBlank((CharSequence)this.vendorName)) {
            throw new MojoFailureException("Invalid vendor name");
        }
        if (StringUtils.isBlank((CharSequence)this.feature)) {
            throw new MojoFailureException("Invalid feature id");
        }
        if (StringUtils.isBlank((CharSequence)this.licenseName)) {
            throw new MojoFailureException("Invalid license name");
        }
        this.daysToExpiration = this.daysToExpiration == null ? "" : this.daysToExpiration;
        String string = this.validVersions = this.validVersions == null ? "" : this.validVersions;
        if (!StringUtils.isBlank((CharSequence)this.validVersions)) {
            Matcher rangeMatcher = Pattern.compile("(\\[|\\()([^,]*),(.*)(\\]|\\))").matcher(this.validVersions);
            if (!rangeMatcher.matches()) {
                throw new MojoFailureException("Invalid version format " + this.validVersions + ". Version format should be maven-like, ie: [,3.0.0]");
            }
            Pattern versionPattern = Pattern.compile("^([0-9])\\.([0-9]|x)\\.([0-9]|x)\\-?(.*SNAPSHOT)?$");
            if (!StringUtils.isBlank((CharSequence)rangeMatcher.group(2)) && !versionPattern.matcher(rangeMatcher.group(2)).matches()) {
                throw new MojoFailureException("Invalid version format " + this.validVersions + ". Version format should be maven-like, ie: [,3.0.0]");
            }
            if (!StringUtils.isBlank((CharSequence)rangeMatcher.group(3)) && !versionPattern.matcher(rangeMatcher.group(3)).matches()) {
                throw new MojoFailureException("Invalid version format " + this.validVersions + ". Version format should be maven-like, ie: [,3.0.0]");
            }
        }
    }
}

