/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.mojo;

import java.io.FileInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.tools.devkit.core.KeyHandler;
import org.mule.tools.devkit.core.SignatureHandler;

@Mojo(name="verify", requiresProject=false)
public class SignVerifierMojo
extends AbstractMojo {
    @Parameter(required=true, property="signature")
    private String signatureFile;
    @Parameter(required=true, property="keystore")
    protected String keystore;
    @Parameter(required=true, property="key.name")
    protected String alias;
    @Parameter(required=true, property="data")
    protected String data;

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean verified;
        if (StringUtils.isBlank((CharSequence)this.keystore) || !Files.exists(Paths.get(this.keystore, new String[0]), new LinkOption[0])) {
            throw new MojoFailureException("Invalid keystore file: " + this.keystore);
        }
        if (StringUtils.isBlank((CharSequence)this.data) || !Files.exists(Paths.get(this.data, new String[0]), new LinkOption[0])) {
            throw new MojoFailureException("Invalid data file: " + this.data);
        }
        try {
            char[] password = System.console().readPassword("* Enter keystore password: ", new Object[0]);
            verified = SignatureHandler.verify(this.signatureFile, KeyHandler.loadPub(this.alias, new FileInputStream(this.keystore), password), this.data);
        }
        catch (Exception e) {
            throw new MojoFailureException("Failed to verify signature of " + this.data + " with the keystore " + this.keystore);
        }
        if (!verified) {
            throw new MojoFailureException(String.format("Signature of Data file [%s] using the keystore [%s] does not match the expected signature", this.data, this.keystore));
        }
        this.getLog().info((CharSequence)"Signature is a match!");
    }
}

