/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.template;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractInfoTemplate {
    public static final String DATE_FORMAT = "ddMMyyyy";
    public static final int DEFAULT_EXPIRATION_DAYS = 365;
    public static final String VENDOR_NAME_KEY = "vendor.name";
    public static final String CREATION_DATE_KEY = "creation.date";
    public static final String EXPIRATION_DATE_KEY = "expiration.date";
    public static final String VERSIONS_KEY = "valid.versions";
    protected String vendorName;
    protected String creationDate;
    protected String expirationDate;
    protected String validVersions;

    public AbstractInfoTemplate(String vendorName, String daysToExpiration, String validVersions) {
        this.vendorName = vendorName;
        this.creationDate = new SimpleDateFormat(DATE_FORMAT).format(new Date());
        this.expirationDate = this.calculateExpirationDate(daysToExpiration);
        this.validVersions = validVersions;
    }

    protected String calculateExpirationDate(String expirationDays) {
        int daysInFuture;
        int n = daysInFuture = StringUtils.isBlank((CharSequence)expirationDays) ? 365 : Integer.parseInt(expirationDays);
        if (daysInFuture < 1) {
            return "";
        }
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(6, daysInFuture);
        return new SimpleDateFormat(DATE_FORMAT).format(c.getTime());
    }

    protected byte[] build(Properties info) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            info.store(os, "");
            return os.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

