/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.tools.devkit.lic.mojo;

import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.mule.tools.devkit.lic.security.KeyHandler;
import org.mule.tools.devkit.lic.security.SignatureHandler;

import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.security.PrivateKey;

@Mojo(name = "sign", requiresProject = false)
public class FileSignerMojo extends AbstractSecurityMojo {


    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();

        try {
            Console console = System.console();
            char[] password = console.readPassword("Enter your keystore password: ");
            PrivateKey privateKey = KeyHandler.loadPrv(alias, new FileInputStream(keystore), password);

            byte[] signedData = SignatureHandler.sign(new FileInputStream(data), privateKey, KeyHandler.SHA_512_WITH_RSA);
            FileUtils.writeByteArrayToFile(new File(FilenameUtils.getName(data) + ".sig"), signedData);
        } catch (Exception e) {
            e.printStackTrace();
            throw new MojoFailureException("Failed to sign " + data + " with the keystore " + keystore);
        }
    }
}
