package org.mule.tools.devkit.lic.mojo;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;

/**
 * @author MuleSoft, Inc
 */
@Mojo(name = "help", requiresProject = false)
public class LicenseHelpMojo extends AbstractMojo {

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {

        getLog().info(" ");
        getLog().info("mule-devkit-license:license goal");
        getLog().info(" ");
        getLog().info(" [required] vendor.keystore: Path to the vendor .jks");
        getLog().info(" [required] client: Name of client to which this license is handed");
        getLog().info(" [required] entitlement.provider: attribute \"provider\" name as it appears in the @RequiresEntitlement annotation of the Connector");
        getLog().info(" [required] entitlement.name: attribute \"name\" as it appears in the @RequiresEntitlement annotation of the Connector");
        getLog().info(" [required] connector.name: attribute \"name\" of the @Connector");
        getLog().info(" [optional] days.to.expire: Number of days for which this license will be valid");
        getLog().info(" ");
    }

}
