/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.tools.devkit.lic.mojo;

import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.tools.devkit.lic.security.KeyHandler;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;

@Mojo(name = "encrypt", requiresProject = false)
public class FileEncryptMojo extends AbstractSecurityMojo {

    @Parameter(property="use.pub", defaultValue = "true")
    private boolean usePublic;

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();

        try {
            byte[] encryptedData = KeyHandler.encrypt(Files.readAllBytes(Paths.get(data)), getKey(usePublic));
            FileUtils.writeByteArrayToFile(new File(FilenameUtils.getName(data) + ".enc"), encryptedData);
        } catch (Exception e) {
            e.printStackTrace();
            throw new MojoFailureException("Failed to encrypt " + data + " with the keystore " + keystore);
        }
    }

}
