/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.tools.devkit.lic.mojo;

import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.tools.devkit.lic.security.KeyHandler;

import java.io.Console;
import java.io.FileInputStream;
import java.nio.file.Paths;

@Mojo(name = "getpub", requiresProject = false)
public class GetPublicKeyMojo extends AbstractMojo {

    @Parameter(required = true, property = "keystore")
    private String keystore;

    @Parameter(required = true, property = "key.name")
    private String alias;

    public void execute() throws MojoExecutionException, MojoFailureException {

        if (StringUtils.isBlank(keystore) || !Paths.get(keystore).toFile().exists()){
            throw new MojoFailureException("Invalid keystore path :" + keystore);
        }

        if (StringUtils.isBlank(alias)){
            throw new MojoExecutionException("[key.name] cannot be null or empty");
        }

        Console console = System.console();
        char[] password = console.readPassword("Enter your keystore password: ");

        try {
            byte[] pubKey = KeyHandler.loadPub(alias, new FileInputStream(keystore), password).getEncoded();
            FileUtils.writeByteArrayToFile(Paths.get(alias.concat(".pub")).toFile(), pubKey);
        } catch (Exception e) {
            e.printStackTrace();
            throw new MojoFailureException("Failed to extract the public key from the given keystore");
        }
    }

}
