/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.lic.mojo;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.tools.devkit.lic.security.KeyHandler;
import org.mule.tools.devkit.lic.security.KeyStoreException;
import org.mule.tools.devkit.lic.security.ZippedBundle;
import org.mule.tools.devkit.lic.template.VendorInfoTemplate;

@Mojo(name="vendorkey", requiresProject=false)
public class VendorKeyGenerationMojo
extends AbstractMojo {
    @Parameter(required=false, property="mule.keystore")
    private String muleKS;
    @Parameter(required=false, property="vendor.keystore")
    private String vendorKS;
    @Parameter(required=true, property="provider.name")
    private String providerName;
    @Parameter(required=true, property="connector.name")
    private String connectorName;
    @Parameter(required=true, property="contact.email")
    private String email;
    @Parameter(required=true, property="contact.msg")
    private String contactMsg;
    @Parameter(required=false, property="days.to.expire", defaultValue="-1")
    private String daysToExpiration;
    @Parameter(required=false, property="versions", defaultValue="")
    private String validVersions;
    private String keyName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.initialise();
        this.keyName = this.providerName + "-" + this.connectorName;
        try {
            PrivateKey mulePrivateKey = this.getMulePrivateKey();
            ZippedBundle bundle = new ZippedBundle(Paths.get(this.keyName + ".key", new String[0]).toString());
            byte[] encryptedPub = KeyHandler.encrypt(this.getVendorsPublicKey().getEncoded(), mulePrivateKey);
            bundle.addEntry(this.keyName.concat(".pub"), new ByteArrayInputStream(encryptedPub));
            byte[] encryptedInfo = KeyHandler.encrypt(this.buildInfo(), mulePrivateKey);
            bundle.addEntry(this.keyName.concat(".info"), new ByteArrayInputStream(encryptedInfo));
            bundle.export();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoFailureException("Failed to create a connector key using the given keystore: " + e.getMessage());
        }
    }

    private byte[] buildInfo() {
        return new VendorInfoTemplate(this.providerName, this.connectorName, this.daysToExpiration, this.validVersions, this.email, this.contactMsg).build();
    }

    private PublicKey getVendorsPublicKey() throws KeyStoreException {
        char[] password = System.console().readPassword("* Enter Vendor's keystore password: ", new Object[0]);
        try {
            return KeyHandler.loadPub(this.keyName, new FileInputStream(this.vendorKS), password);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KeyStoreException("Failed to retrieve Public Key from keystore " + this.vendorKS + ": " + e.getMessage());
        }
    }

    private PrivateKey getMulePrivateKey() throws KeyStoreException {
        char[] password = System.console().readPassword("* Enter MuleSoft keystore password: ", new Object[0]);
        try {
            return KeyHandler.loadPrv("mule", new FileInputStream(this.muleKS), password);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KeyStoreException("Failed to retrieve Private Key from KeyStore " + this.muleKS + ": " + e.getMessage());
        }
    }

    private void initialise() throws MojoFailureException {
        if (StringUtils.isBlank((CharSequence)this.providerName)) {
            throw new MojoFailureException("Invalid vendor name: " + this.providerName);
        }
        if (StringUtils.isBlank((CharSequence)this.connectorName)) {
            throw new MojoFailureException("Invalid connector name: " + this.connectorName);
        }
        if (!Files.exists(Paths.get(this.muleKS, new String[0]), new LinkOption[0])) {
            throw new MojoFailureException("Invalid path to MuleSoft keystore file: " + this.muleKS);
        }
        if (!Files.exists(Paths.get(this.vendorKS, new String[0]), new LinkOption[0])) {
            throw new MojoFailureException("Invalid path to " + this.providerName + " keystore file: " + this.vendorKS);
        }
        this.daysToExpiration = this.daysToExpiration == null ? "" : this.daysToExpiration;
        this.validVersions = this.validVersions == null ? "" : this.validVersions;
    }
}

