/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.lic.security;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;

public class KeyHandler {
    public static final String RSA = "RSA";
    public static final String RSA_ECB_TRANSFORMATION = "RSA/ECB/PKCS1Padding";
    public static final String SHA_512_WITH_RSA = "SHA512withRSA";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generatePair(String publicName, String privateName, int keySize) throws NoSuchAlgorithmException, IOException {
        KeyPairGenerator gen = KeyPairGenerator.getInstance(RSA);
        gen.initialize(keySize);
        KeyPair key = gen.generateKeyPair();
        PrivateKey privateKey = key.getPrivate();
        PublicKey publicKey = key.getPublic();
        try (FileOutputStream pvt = new FileOutputStream(privateName);){
            pvt.write(privateKey.getEncoded());
            pvt.flush();
        }
        try (FileOutputStream pub = new FileOutputStream(publicName);){
            pub.write(publicKey.getEncoded());
            pub.flush();
        }
    }

    public static PublicKey loadPub(String keyName, InputStream keystoreIS, char[] password) throws Exception {
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        keystore.load(keystoreIS, password);
        Key key = keystore.getKey(keyName, password);
        if (key instanceof PrivateKey) {
            return keystore.getCertificate(keyName).getPublicKey();
        }
        throw new RuntimeException("Public key " + keyName + " not found");
    }

    public static PrivateKey loadPrv(String keyName, InputStream keystoreIS, char[] password) throws Exception {
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        keystore.load(keystoreIS, password);
        Key key = keystore.getKey(keyName, password);
        if (key instanceof PrivateKey) {
            return (PrivateKey)key;
        }
        throw new RuntimeException("Private key " + keyName + " not found");
    }

    public static PrivateKey loadPrv(InputStream keyIS) throws NoSuchAlgorithmException, IOException, InvalidKeySpecException {
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(IOUtils.toByteArray((InputStream)keyIS));
        return KeyFactory.getInstance(RSA).generatePrivate(pkcs8EncodedKeySpec);
    }

    public static PublicKey loadPub(InputStream keyIS) throws NoSuchAlgorithmException, IOException, InvalidKeySpecException {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(IOUtils.toByteArray((InputStream)keyIS));
        return KeyFactory.getInstance(RSA).generatePublic(x509EncodedKeySpec);
    }

    public static byte[] encrypt(byte[] data, Key key) throws Exception {
        return KeyHandler.encrypt(data, key, RSA_ECB_TRANSFORMATION);
    }

    public static byte[] encrypt(byte[] data, Key key, String transformation) throws Exception {
        Cipher cipher = Cipher.getInstance(transformation);
        cipher.init(1, key);
        return Base64.encodeBase64((byte[])cipher.doFinal(data));
    }

    public static byte[] decrypt(byte[] data, Key key) throws Exception {
        return KeyHandler.decrypt(data, key, RSA_ECB_TRANSFORMATION);
    }

    public static byte[] decrypt(byte[] data, Key key, String transformation) throws Exception {
        Cipher cipher = Cipher.getInstance(transformation);
        cipher.init(2, key);
        return cipher.doFinal(Base64.decodeBase64((byte[])data));
    }
}

