/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.tools.devkit.lic.mojo;

import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.tools.devkit.lic.security.KeyHandler;

@Mojo(name = "keygen", requiresProject = false)
public class KeyPairGenerationMojo extends AbstractMojo {

    @Parameter(required = true, property = "key.name")
    private String keyName;

    @Parameter(property = "key.size", defaultValue = "2048")
    private Integer keySize;

    public void execute() throws MojoExecutionException, MojoFailureException {

        if (StringUtils.isBlank(keyName)){
            throw new MojoFailureException("Invalid key name: " + keyName);
        }

        if ((keySize % 1024) != 0){
            throw new MojoFailureException("Invalid algorithm key size: " + keySize + " must be multiple of 1024");
        }

        try {
            KeyHandler.generatePair(keyName + ".pub", keyName + ".prv", keySize);
        } catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage());
        }
    }
}
