/**
 * (c) 2003-2015 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.tools.devkit.lic.security;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.*;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/**
 * @author MuleSoft, Inc
 */
public class ZippedBundle {

    private final String fileName;
    private Map<String, InputStream> entries = new HashMap<>();

    public ZippedBundle(String fileName) throws InvalidPathException {
        if (StringUtils.isBlank(fileName)){
            throw new IllegalArgumentException("Empty path for zip bundle");
        }
        if (Files.exists(Paths.get(fileName))){
            throw new IllegalArgumentException("File "+ fileName +" already exists");
        }
        this.fileName = fileName;
    }

    public void addEntry (String name, InputStream data){
        if (StringUtils.isBlank(name)){
            throw new IllegalArgumentException("Entry name cannot be null nor empty");
        }
        if (data == null){
            throw new IllegalArgumentException("InputStream for Entry data cannot be null");
        }

        entries.put(name, data);
    }

    public void export() throws IOException {
        ZipOutputStream zip = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(fileName)));

        for (String entryName: entries.keySet()){
            zip.putNextEntry(new ZipEntry(entryName));

            InputStream in = entries.get(entryName);
            try{
                byte[] buffer = new byte[1024];
                int len;
                while ((len = in.read(buffer)) > 0) {
                    zip.write(buffer, 0, len);
                }
            } finally {
                IOUtils.closeQuietly(in);
                zip.closeEntry();
            }
        }

        IOUtils.closeQuietly(zip);
        entries = new HashMap<>();
    }
}
