/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.devkit.lic.security;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class ZippedBundle {
    private final String fileName;
    private Map<String, InputStream> entries = new HashMap<String, InputStream>();

    public ZippedBundle(String fileName) throws InvalidPathException {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            throw new IllegalArgumentException("Empty path for zip bundle");
        }
        if (Files.exists(Paths.get(fileName, new String[0]), new LinkOption[0])) {
            throw new IllegalArgumentException("File " + fileName + " already exists");
        }
        this.fileName = fileName;
    }

    public void addEntry(String name, InputStream data) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Entry name cannot be null nor empty");
        }
        if (data == null) {
            throw new IllegalArgumentException("InputStream for Entry data cannot be null");
        }
        this.entries.put(name, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export() throws IOException {
        ZipOutputStream zip = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.fileName)));
        for (String entryName : this.entries.keySet()) {
            zip.putNextEntry(new ZipEntry(entryName));
            InputStream in = this.entries.get(entryName);
            try {
                int len;
                byte[] buffer = new byte[1024];
                while ((len = in.read(buffer)) > 0) {
                    zip.write(buffer, 0, len);
                }
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
                zip.closeEntry();
            }
        }
        IOUtils.closeQuietly((OutputStream)zip);
        this.entries = new HashMap<String, InputStream>();
    }
}

