/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.maven;

import java.io.File;
import java.io.FilenameFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.jfrog.maven.annomojo.annotations.MojoComponent;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;
import org.jfrog.maven.annomojo.annotations.MojoPhase;
import org.jfrog.maven.annomojo.annotations.MojoRequiresDependencyResolution;

@MojoGoal(value="attach-schema")
@MojoRequiresDependencyResolution(value="compile")
@MojoPhase(value="package")
public class AttachSchemaMojo
extends AbstractMojo {
    @MojoComponent
    protected MavenProjectHelper projectHelper;
    @MojoParameter(expression="${project}", readonly=true, required=true)
    protected MavenProject project;
    @MojoParameter(required=false, defaultValue="target/generated-sources/mule/META-INF")
    protected File targetDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        for (File file : this.targetDirectory.listFiles(new SchemaFilenameFilter())) {
            this.projectHelper.attachArtifact(this.project, "xsd", file);
        }
    }

    private class SchemaFilenameFilter
    implements FilenameFilter {
        private SchemaFilenameFilter() {
        }

        public boolean accept(File file, String s) {
            return s.startsWith("mule-") && s.endsWith("xsd");
        }
    }
}

