/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.maven;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProjectHelper;
import org.jfrog.maven.annomojo.annotations.MojoComponent;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;
import org.jfrog.maven.annomojo.annotations.MojoPhase;
import org.jfrog.maven.annomojo.annotations.MojoRequiresDependencyResolution;
import org.mule.api.annotations.Configurable;
import org.mule.api.annotations.Module;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.param.Optional;
import org.mule.api.annotations.rest.HttpMethod;
import org.mule.api.annotations.rest.RestCall;
import org.mule.api.annotations.rest.RestHeaderParam;
import org.mule.api.annotations.rest.RestQueryParam;
import org.mule.api.annotations.rest.RestUriParam;
import org.mule.devkit.maven.AbstractMuleMojo;
import org.mule.devkit.model.code.AnnotationUse;
import org.mule.devkit.model.code.AssignmentTarget;
import org.mule.devkit.model.code.CatchBlock;
import org.mule.devkit.model.code.ClassAlreadyExistsException;
import org.mule.devkit.model.code.ClassType;
import org.mule.devkit.model.code.CodeModel;
import org.mule.devkit.model.code.CodeWriter;
import org.mule.devkit.model.code.DefinedClass;
import org.mule.devkit.model.code.Expression;
import org.mule.devkit.model.code.ExpressionFactory;
import org.mule.devkit.model.code.FieldVariable;
import org.mule.devkit.model.code.Invocation;
import org.mule.devkit.model.code.Method;
import org.mule.devkit.model.code.Op;
import org.mule.devkit.model.code.Package;
import org.mule.devkit.model.code.Statement;
import org.mule.devkit.model.code.TryStatement;
import org.mule.devkit.model.code.Type;
import org.mule.devkit.model.code.TypeReference;
import org.mule.devkit.model.code.Variable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@MojoPhase(value="generate-sources")
@MojoGoal(value="generate-mashape-client")
@MojoRequiresDependencyResolution(value="runtime")
public class MashapeGeneratorMojo
extends AbstractMuleMojo {
    @MojoComponent
    private MavenProjectHelper projectHelper;
    @MojoParameter(expression="${project.basedir}/src/main/resources", required=true)
    private File inputFolder;
    @MojoParameter(expression="${project.build.directory}/generated-sources/mashape", required=true)
    private File defaultOutputDirectory;
    @MojoParameter(required=false)
    private String mashapeName;
    @MojoParameter(required=false)
    private String mashapeVersion;
    @MojoParameter(required=false)
    private String mashapeProxyHost;
    private CodeModel codeModel = new CodeModel(new CodeWriter(){

        public OutputStream openBinary(Package pkg, String fileName) throws IOException {
            File file = new File(MashapeGeneratorMojo.this.defaultOutputDirectory, pkg.name().replace(".", "/") + "/" + fileName);
            return FileUtils.openOutputStream((File)file);
        }

        public void close() throws IOException {
        }
    });

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.inputFolder == null) {
            return;
        }
        this.getLog().info((CharSequence)("Source directory: " + this.defaultOutputDirectory.getAbsolutePath() + " added"));
        this.project.addCompileSourceRoot(this.defaultOutputDirectory.getAbsolutePath());
        try {
            this.traverse(this.inputFolder);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void traverse(File f) throws IOException, MojoExecutionException {
        File[] childs = f.listFiles();
        if (childs != null) {
            for (File child : childs) {
                if (child.isDirectory()) {
                    this.traverse(child);
                    continue;
                }
                if (!FilenameUtils.isExtension((String)child.getAbsolutePath(), (String)"mashape")) continue;
                this.generateMashapeClient(child);
            }
        }
    }

    private void generateMashapeClient(File inputFile) throws MojoExecutionException {
        if (this.mashapeName == null) {
            throw new MojoExecutionException("You must specify a mashapeName");
        }
        if (this.mashapeVersion == null) {
            throw new MojoExecutionException("You must specify a mashapeVersion");
        }
        if (this.mashapeProxyHost == null) {
            throw new MojoExecutionException("You must specify a mashapeProxyHost");
        }
        this.getLog().info((CharSequence)("Generating POJO for " + inputFile.getAbsolutePath()));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        try {
            db = factory.newDocumentBuilder();
            Document dom = db.parse(inputFile);
            DefinedClass clazz = this.codeModel._class(33, "org.mule.modules.tinypayme.TinyPayMeConnector", ClassType.CLASS);
            clazz.javadoc().add((Object)"Unkown\n\nAutomatically generated from Mashape XML file\n\n@author MuleSoft, Inc.");
            AnnotationUse moduleAnnotation = clazz.annotate(Module.class);
            moduleAnnotation.param("name", this.mashapeName);
            moduleAnnotation.param("schemaVersion", this.mashapeVersion);
            FieldVariable mashapePrivateKey = this.generateMashapePrivateKey(clazz);
            FieldVariable mashapePublicKey = this.generateMashapePublicKeyField(clazz);
            FieldVariable mashapeAuthorization = this.generateMashapeAuthorizationField(clazz);
            this.generateInit(clazz, mashapePrivateKey, mashapePublicKey, mashapeAuthorization);
            Node api = dom.getElementsByTagName("api").item(0);
            NodeList methods = api.getChildNodes();
            for (int i = 0; i < methods.getLength(); ++i) {
                int j;
                String uri;
                Node method = methods.item(i);
                if (!"method".equals(method.getNodeName())) continue;
                Method restCallMethod = clazz.method(33, (Type)this.ref(String.class), method.getAttributes().getNamedItem("name").getNodeValue());
                restCallMethod._throws(this.ref(IOException.class));
                restCallMethod.annotate(Processor.class);
                AnnotationUse restCall = restCallMethod.annotate(RestCall.class);
                Node url = null;
                for (int j2 = 0; j2 < method.getChildNodes().getLength(); ++j2) {
                    if (!"url".equals(method.getChildNodes().item(j2).getNodeName())) continue;
                    url = method.getChildNodes().item(j2);
                    break;
                }
                if ((uri = url.getTextContent()).contains("?")) {
                    uri = uri.split("\\?")[0];
                }
                restCall.param("uri", "https://" + this.mashapeProxyHost + uri);
                if ("GET".equals(method.getAttributes().getNamedItem("http").getNodeValue())) {
                    restCall.param("method", (Expression)this.ref(HttpMethod.class).staticRef("GET"));
                } else if ("PUT".equals(method.getAttributes().getNamedItem("http").getNodeValue())) {
                    restCall.param("method", (Expression)this.ref(HttpMethod.class).staticRef("PUT"));
                } else if ("POST".equals(method.getAttributes().getNamedItem("http").getNodeValue())) {
                    restCall.param("method", (Expression)this.ref(HttpMethod.class).staticRef("POST"));
                }
                Node parameters = null;
                for (j = 0; j < method.getChildNodes().getLength(); ++j) {
                    if (!"parameters".equals(method.getChildNodes().item(j).getNodeName())) continue;
                    parameters = method.getChildNodes().item(j);
                    break;
                }
                for (j = 0; j < parameters.getChildNodes().getLength(); ++j) {
                    if (!"parameter".equals(parameters.getChildNodes().item(j).getNodeName())) continue;
                    Node parameter = parameters.getChildNodes().item(j);
                    Variable restCallParameter = restCallMethod.param((Type)this.ref(String.class), StringUtils.uncapitalize((String)this.camel(parameter.getTextContent())));
                    if (uri.contains("{" + parameter.getTextContent() + "}")) {
                        AnnotationUse restUriParam = restCallParameter.annotate(this.ref(RestUriParam.class));
                        restUriParam.param("value", parameter.getTextContent());
                    } else {
                        AnnotationUse restQueryParam = restCallParameter.annotate(this.ref(RestQueryParam.class));
                        restQueryParam.param("value", parameter.getTextContent());
                    }
                    if (parameter.getAttributes().getNamedItem("optional") == null || !"true".equals(parameter.getAttributes().getNamedItem("optional").getNodeValue())) continue;
                    restCallParameter.annotate(this.ref(Optional.class));
                }
            }
            this.codeModel.build();
        }
        catch (ParserConfigurationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (SAXException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (ClassAlreadyExistsException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private String camel(String uncamelCaseName) {
        String result = "";
        String[] parts = uncamelCaseName.split("_");
        for (int i = 0; i < parts.length; ++i) {
            result = result + StringUtils.capitalize((String)parts[i].toLowerCase());
        }
        return result;
    }

    private FieldVariable generateMashapePrivateKey(DefinedClass clazz) {
        FieldVariable mashapePrivateKey = clazz.field(4, (Type)this.ref(String.class), "mashapePrivateKey");
        mashapePrivateKey.javadoc().add((Object)"Mashape Private Key");
        mashapePrivateKey.annotate(Configurable.class);
        Method setMashapePrivateKey = clazz.method(1, (Type)this.codeModel.VOID, "setMashapePrivateKey");
        Variable thatMashapePrivateKey = setMashapePrivateKey.param((Type)this.ref(String.class), "newMashapePrivateKey");
        setMashapePrivateKey.body().assign((AssignmentTarget)mashapePrivateKey, (Expression)thatMashapePrivateKey);
        return mashapePrivateKey;
    }

    private FieldVariable generateMashapePublicKeyField(DefinedClass clazz) {
        FieldVariable mashapePublicKey = clazz.field(4, (Type)this.ref(String.class), "mashapePublicKey");
        mashapePublicKey.javadoc().add((Object)"Mashape Public Key");
        mashapePublicKey.annotate(Configurable.class);
        Method setMashapePublicKey = clazz.method(1, (Type)this.codeModel.VOID, "setMashapePublicKey");
        Variable thatMashapePublicKey = setMashapePublicKey.param((Type)this.ref(String.class), "newMashapePublicKey");
        setMashapePublicKey.body().assign((AssignmentTarget)mashapePublicKey, (Expression)thatMashapePublicKey);
        return mashapePublicKey;
    }

    private FieldVariable generateMashapeAuthorizationField(DefinedClass clazz) {
        FieldVariable mashapeAuthorization = clazz.field(4, (Type)this.ref(String.class), "mashapeAuthorization");
        mashapeAuthorization.javadoc().add((Object)"Mashape Authorization");
        AnnotationUse mashapeAuthorizationRestHeaderParam = mashapeAuthorization.annotate(this.ref(RestHeaderParam.class));
        mashapeAuthorizationRestHeaderParam.param("value", "X-Mashape-Authorization");
        Method getMashapeAuthorization = clazz.method(1, (Type)this.ref(String.class), "getMashapeAuthorization");
        getMashapeAuthorization.body()._return((Expression)mashapeAuthorization);
        return mashapeAuthorization;
    }

    private void generateInit(DefinedClass clazz, FieldVariable mashapePrivateKey, FieldVariable mashapePublicKey, FieldVariable mashapeAuthorization) {
        Method init = clazz.method(1, (Type)this.codeModel.VOID, "init");
        init.annotate(this.ref(PostConstruct.class));
        TryStatement attempt = init.body()._try();
        Variable uuid = attempt.body().decl((Type)this.ref(String.class), "uuid", (Expression)this.ref(UUID.class).staticInvoke("randomUUID").invoke("toString"));
        Variable signingKey = attempt.body().decl((Type)this.ref(SecretKeySpec.class), "signingKey", (Expression)ExpressionFactory._new((TypeReference)this.ref(SecretKeySpec.class)).arg((Expression)mashapePrivateKey.invoke("getBytes")).arg("HmacSHA1"));
        Variable mac = attempt.body().decl((Type)this.ref(Mac.class), "mac", (Expression)this.ref(Mac.class).staticInvoke("getInstance").arg("HmacSHA1"));
        attempt.body().add((Statement)mac.invoke("init").arg((Expression)signingKey));
        Variable rawHmac = attempt.body().decl((Type)this.codeModel.BYTE.array(), "rawHmac", (Expression)mac.invoke("doFinal").arg((Expression)uuid.invoke("getBytes")));
        Variable hex = attempt.body().decl((Type)this.codeModel.BYTE.array(), "hex", (Expression)ExpressionFactory._new((TypeReference)this.ref(Hex.class)).invoke("encode").arg((Expression)rawHmac));
        Variable headerValue = attempt.body().decl((Type)this.ref(String.class), "headerValue", Op.plus((Expression)Op.plus((Expression)Op.plus((Expression)mashapePublicKey, (Expression)ExpressionFactory.lit((String)":")), (Expression)ExpressionFactory._new((TypeReference)this.ref(String.class)).arg((Expression)hex).arg("UTF-8")), (Expression)uuid));
        Invocation getHeaderValueBytes = this.ref(Base64.class).staticInvoke("encodeBase64String").arg((Expression)headerValue.invoke("getBytes"));
        attempt.body().assign((AssignmentTarget)mashapeAuthorization, (Expression)getHeaderValueBytes.invoke("replace").arg("\r\n").arg(""));
        CatchBlock catchUnsupportedEncodingExpception = attempt._catch(this.ref(UnsupportedEncodingException.class));
        catchUnsupportedEncodingExpception.body()._throw((Expression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)));
        CatchBlock catchNoSuchAlgorithmException = attempt._catch(this.ref(NoSuchAlgorithmException.class));
        catchNoSuchAlgorithmException.body()._throw((Expression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)));
        CatchBlock catchInvalidKeyException = attempt._catch(this.ref(InvalidKeyException.class));
        catchInvalidKeyException.body()._throw((Expression)ExpressionFactory._new((TypeReference)this.ref(RuntimeException.class)));
    }

    private TypeReference ref(Class<?> clazz) {
        return this.codeModel.ref(clazz);
    }
}

