/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.maven.studio;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.mule.devkit.maven.studio.TokensReplacer;
import org.mule.devkit.maven.studio.UpdateSiteElementsBuilder;

public class StudioFeatureBuilder
extends UpdateSiteElementsBuilder {
    public static final String FEATURE_SUFIX = "-feature";
    private String path;
    private TokensReplacer tokensReplacer;

    StudioFeatureBuilder(String pluginName, String pluginVersion, String muleAppName, String outputDirectory, String license, File classesDirectory) {
        super(pluginName, pluginVersion, muleAppName, outputDirectory, classesDirectory);
        this.path = this.updateSitePath + "features";
        this.tokensReplacer = new TokensReplacer(this.buildTokens(pluginName, pluginVersion, license));
    }

    private Map<String, String> buildTokens(String pluginName, String pluginVersion, String license) {
        HashMap<String, String> tokens = new HashMap<String, String>();
        tokens.put("%FEATURE_ID%", pluginName + FEATURE_SUFIX);
        tokens.put("%PLUGIN_ID%", pluginName);
        tokens.put("%VERSION%", pluginVersion);
        tokens.put("%LICENSE%", license);
        return tokens;
    }

    @Override
    public File build() throws MojoExecutionException {
        File studioPlugin = new File(this.path, this.pluginName + "_" + this.pluginVersion + ".jar");
        try {
            File file = new File(this.classesDirectory, "feature.xml");
            if (!file.exists()) {
                throw new MojoExecutionException("Error while packaging Mule Studio plugin: " + file.getName() + " does not exist");
            }
            this.tokensReplacer.replaceTokensOn(file);
            JarArchiver archiver = new JarArchiver();
            archiver.addFile(file, file.getName());
            archiver.setDestFile(studioPlugin);
            try {
                studioPlugin.delete();
                archiver.createArchive();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error while packaging Studio plugin", (Exception)e);
            }
            return studioPlugin;
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Exception creating the Mule Plugin", (Exception)((Object)e));
        }
    }
}

