/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.maven.studio;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.mule.devkit.generation.mule.studio.MuleStudioPluginGenerator;
import org.mule.devkit.maven.studio.TokensReplacer;
import org.mule.devkit.maven.studio.UpdateSiteElementsBuilder;

class StudioPluginBuilder
extends UpdateSiteElementsBuilder {
    private String path;
    private TokensReplacer tokensReplacer;

    StudioPluginBuilder(String pluginName, String pluginVersion, String muleAppName, String outputDirectory, File classesDirectory, String projectVersion) {
        super(pluginName, pluginVersion, muleAppName, outputDirectory, classesDirectory);
        this.path = this.updateSitePath + "plugins";
        this.tokensReplacer = new TokensReplacer(this.buildTokens(pluginName, pluginVersion, muleAppName, projectVersion));
    }

    private Map<String, String> buildTokens(String pluginName, String pluginVersion, String muleAppName, String projectVersion) {
        HashMap<String, String> tokens = new HashMap<String, String>();
        tokens.put("%JAR_NAME%", muleAppName + ".jar");
        tokens.put("%ZIP_NAME%", muleAppName + ".zip");
        tokens.put("%BUNDLE_NAME%", pluginName);
        tokens.put("%PROJECT_VERSION%", projectVersion);
        tokens.put("%VERSION%", pluginVersion);
        tokens.put("%SOURCES_JAR%", muleAppName + "-sources.jar");
        tokens.put("%JAVADOC_JAR%", muleAppName + "-javadoc.jar");
        return tokens;
    }

    @Override
    public File build() throws MojoExecutionException {
        try {
            return this.createStudioPlugin();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Exception creating the Mule Plugin", (Exception)((Object)e));
        }
    }

    private File createStudioPlugin() throws MojoExecutionException, ArchiverException {
        File studioPlugin = new File(this.path, this.pluginName + "_" + this.pluginVersion + ".jar");
        JarArchiver archiver = new JarArchiver();
        this.archiveFile(archiver, this.muleAppName + ".zip");
        this.addArchivedClasses(archiver);
        for (String fileName : MuleStudioPluginGenerator.GENERATED_FILES) {
            File file = new File(this.classesDirectory, fileName);
            if (!file.exists()) {
                throw new MojoExecutionException("Error while packaging Mule Studio plugin: " + file.getName() + " does not exist");
            }
            if (fileName.endsWith(".xml")) {
                this.tokensReplacer.replaceTokensOn(file);
            }
            if (this.isManifest(fileName)) {
                this.tokensReplacer.replaceTokensOn(file);
                archiver.setManifest(file);
                continue;
            }
            archiver.addFile(file, file.getPath().substring(file.getPath().indexOf(this.classesDirectory.getPath()) + this.classesDirectory.getPath().length() + 1));
        }
        archiver.addDirectory(new File(this.classesDirectory, "icons/"), "icons/", null, null);
        archiver.setDestFile(studioPlugin);
        try {
            studioPlugin.delete();
            archiver.createArchive();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while packaging Studio plugin", (Exception)e);
        }
        return studioPlugin;
    }

    private boolean isManifest(String fileName) {
        return fileName.endsWith("MF");
    }

    private void archiveFile(JarArchiver archiver, String fileName) throws MojoExecutionException {
        File muleZipFile = new File(this.outputDirectory, fileName);
        if (!muleZipFile.exists()) {
            throw new MojoExecutionException(fileName + " does not exist");
        }
        archiver.addFile(muleZipFile, muleZipFile.getName());
    }

    private void addArchivedClasses(JarArchiver archiver) throws ArchiverException, MojoExecutionException {
        if (!this.classesDirectory.exists()) {
            return;
        }
        JarArchiver jarArchiver = new JarArchiver();
        jarArchiver.addDirectory(this.classesDirectory, null, null);
        File jar = new File(this.outputDirectory, this.muleAppName + ".jar");
        jarArchiver.setDestFile(jar);
        try {
            jarArchiver.createArchive();
            archiver.addFile(jar, jar.getName());
        }
        catch (IOException e) {
            String message = "Cannot create project jar";
            throw new MojoExecutionException("Cannot create project jar", (Exception)e);
        }
    }
}

