/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.maven.studio;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.mule.util.IOUtils;

class TokensReplacer {
    private Map<String, String> tokens;

    public TokensReplacer(Map<String, String> tokens) {
        this.tokens = tokens;
    }

    public void replaceTokensOn(File file) throws MojoExecutionException {
        try {
            String fileContents = IOUtils.toString((InputStream)new FileInputStream(file));
            for (String token : this.tokens.keySet()) {
                fileContents = fileContents.replaceAll(token, this.tokens.get(token));
            }
            IOUtils.copy((Reader)new StringReader(fileContents), (OutputStream)new FileOutputStream(file), (String)"UTF-8");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error replacing tokens in file: " + file.getAbsolutePath(), (Exception)e);
        }
    }
}

