/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.maven;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.jfrog.maven.annomojo.annotations.MojoComponent;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;
import org.jfrog.maven.annomojo.annotations.MojoPhase;
import org.jfrog.maven.annomojo.annotations.MojoRequiresDependencyResolution;
import org.mule.devkit.maven.AbstractMuleMojo;
import org.mule.devkit.maven.ArtifactFilter;
import org.mule.devkit.maven.Exclusion;
import org.mule.devkit.maven.Inclusion;
import org.mule.devkit.maven.ModuleArchiver;

@MojoPhase(value="package")
@MojoGoal(value="package")
@MojoRequiresDependencyResolution(value="runtime")
public class PackageMojo
extends AbstractMuleMojo {
    @MojoComponent
    private MavenProjectHelper projectHelper;
    @MojoParameter(expression="${project.build.outputDirectory}", required=true)
    private File classesDirectory;
    @MojoParameter(expression="${archiveClasses}", defaultValue="false")
    private boolean archiveClasses;
    @MojoParameter
    private List<Exclusion> exclusions;
    @MojoParameter
    private List<Inclusion> inclusions;
    @MojoParameter(defaultValue="true")
    private boolean excludeMuleDependencies;
    @MojoParameter(defaultValue="false")
    private boolean filterAppDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File plugin = this.getMuleZipFile();
        try {
            this.createMulePlugin(plugin);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Exception creating the Mule Plugin", (Exception)((Object)e));
        }
        this.projectHelper.attachArtifact(this.project, "zip", "plugin", plugin);
    }

    protected void createMulePlugin(File plugin) throws MojoExecutionException, ArchiverException {
        ModuleArchiver archiver = new ModuleArchiver();
        this.addAppDirectory(archiver);
        this.addCompiledClasses(archiver);
        this.addDependencies(archiver);
        archiver.setDestFile(plugin);
        try {
            plugin.delete();
            archiver.createArchive();
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Cannot create archive", (Throwable)e);
        }
    }

    private void addAppDirectory(ModuleArchiver archiver) throws ArchiverException {
        if (this.filterAppDirectory) {
            if (this.getFilteredAppDirectory().exists()) {
                archiver.addResources(this.getFilteredAppDirectory());
            }
        } else if (this.appDirectory.exists()) {
            archiver.addResources(this.appDirectory);
        }
    }

    private void addCompiledClasses(ModuleArchiver archiver) throws ArchiverException, MojoExecutionException {
        if (!this.archiveClasses) {
            this.addClassesFolder(archiver);
        } else {
            this.addArchivedClasses(archiver);
        }
    }

    private void addClassesFolder(ModuleArchiver archiver) throws ArchiverException {
        if (this.classesDirectory.exists()) {
            this.getLog().info((CharSequence)"Copying classes directly");
            archiver.addClasses(this.classesDirectory, null, null);
        } else {
            this.getLog().info((CharSequence)(this.classesDirectory + " does not exist, skipping"));
        }
    }

    private void addArchivedClasses(ModuleArchiver archiver) throws ArchiverException, MojoExecutionException {
        if (!this.classesDirectory.exists()) {
            this.getLog().info((CharSequence)(this.classesDirectory + " does not exist, skipping"));
            return;
        }
        this.getLog().info((CharSequence)"Copying classes as a jar");
        JarArchiver jarArchiver = new JarArchiver();
        jarArchiver.addDirectory(this.classesDirectory, null, null);
        File jar = new File(this.outputDirectory, this.finalName + ".jar");
        jarArchiver.setDestFile(jar);
        try {
            jarArchiver.createArchive();
            archiver.addLib(jar);
        }
        catch (IOException e) {
            String message = "Cannot create project jar";
            this.getLog().error((CharSequence)"Cannot create project jar", (Throwable)e);
            throw new MojoExecutionException("Cannot create project jar", (Exception)e);
        }
    }

    private void addDependencies(ModuleArchiver archiver) throws ArchiverException {
        for (Artifact artifact : this.getArtifactsToArchive()) {
            String message = String.format("Adding <%1s> as a lib", artifact.getId());
            this.getLog().info((CharSequence)message);
            archiver.addLib(artifact.getFile());
        }
    }

    private Set<Artifact> getArtifactsToArchive() {
        ArtifactFilter filter = new ArtifactFilter(this.project, this.inclusions, this.exclusions, this.excludeMuleDependencies);
        return filter.getArtifactsToArchive();
    }
}

