/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.maven;

import java.util.Arrays;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.mule.devkit.maven.AbstractMuleMojo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="filter-resources", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class FilterResourcesMojo
extends AbstractMuleMojo {
    @Component(role=MavenResourcesFiltering.class, hint="default")
    private MavenResourcesFiltering resourceFilter;
    @Parameter(property="project.build.sourceEncoding", defaultValue="${encoding}")
    private String encoding;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="false")
    private boolean filterAppDirectory;
    @Parameter(defaultValue="true")
    private boolean escapeWindowsPaths;
    @Parameter(defaultValue="false")
    private boolean supportMultiLineFiltering;
    @Parameter
    private List<?> nonFilteredFileExtensions;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.filterAppDirectory) {
            return;
        }
        this.getLog().info((CharSequence)("filtering resources from " + this.appDirectory.getAbsolutePath()));
        this.filterResources();
    }

    private void filterResources() throws MojoExecutionException {
        try {
            MavenResourcesExecution execution = new MavenResourcesExecution(this.getResources(), this.getFilteredAppDirectory(), this.project, this.encoding, null, null, this.session);
            execution.setEscapeWindowsPaths(this.escapeWindowsPaths);
            execution.setSupportMultiLineFiltering(this.supportMultiLineFiltering);
            if (this.nonFilteredFileExtensions != null) {
                execution.setNonFilteredFileExtensions(this.nonFilteredFileExtensions);
            }
            this.resourceFilter.filterResources(execution);
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException("Error while filtering Mule config files", (Exception)((Object)e));
        }
    }

    private List<Resource> getResources() {
        Resource appFolderResource = new Resource();
        appFolderResource.setDirectory(this.appDirectory.getAbsolutePath());
        appFolderResource.setFiltering(true);
        return Arrays.asList(appFolderResource);
    }
}

