/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.maven.model.License;
import org.apache.maven.plugin.logging.Log;
import org.mule.devkit.apt.MavenLicense;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenLicenseBuilder {
    private static final List<String> POSSIBLE_LICENSE_FILE_NAMES = Arrays.asList("LICENSE.md", "license.txt", "License.md");
    private static final String LICENSE_DEFAULT_FILENAME = POSSIBLE_LICENSE_FILE_NAMES.get(0);
    private Log log;
    private File defaultLicenseFile;
    private List<File> possibleLicenseFiles = new ArrayList<File>();
    private List<License> pomFoundLicenses;

    public MavenLicenseBuilder(Log log, File basedir, List<License> licenses) {
        this.log = log;
        this.defaultLicenseFile = new File(basedir, LICENSE_DEFAULT_FILENAME);
        this.pomFoundLicenses = licenses;
        for (String licenseFileName : POSSIBLE_LICENSE_FILE_NAMES) {
            this.possibleLicenseFiles.add(new File(basedir, licenseFileName));
        }
    }

    public List<String> getPossibleLicenseFileNames() {
        return POSSIBLE_LICENSE_FILE_NAMES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenLicense build() {
        File licenseFile = null;
        String licenseBody = null;
        for (File possibleLicenseFile : this.possibleLicenseFiles) {
            if (!possibleLicenseFile.exists()) continue;
            licenseFile = possibleLicenseFile;
            break;
        }
        if (licenseFile != null) {
            try {
                licenseBody = this.readLicenseBodyFromFile(licenseFile);
            }
            catch (IOException e) {
                this.log.warn((CharSequence)(String.format("License could not be read from %s: ", licenseFile) + e.getLocalizedMessage()));
                this.log.debug((CharSequence)"Falling back to reading license from pom.xml.");
            }
        }
        if (licenseBody == null) {
            MavenLicense license = this.licenseFromPom();
            if (license == null || license.getLicenseBody().equals("")) {
                this.log.error((CharSequence)"No license will be used in the Studio plugin: No content was found at that location");
                return null;
            }
            FileWriter fileWriter = null;
            try {
                fileWriter = new FileWriter(this.defaultLicenseFile);
                IOUtils.copy((Reader)new StringReader(licenseBody), (Writer)fileWriter);
            }
            catch (IOException e) {
                try {
                    this.log.warn((CharSequence)("No license file could be saved in: " + this.defaultLicenseFile));
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileWriter);
                    throw throwable;
                }
                IOUtils.closeQuietly((Writer)fileWriter);
            }
            IOUtils.closeQuietly((Writer)fileWriter);
        }
        String url = this.getLicenseURLFromPom();
        return new MavenLicense(licenseBody, url);
    }

    private String getLicenseURLFromPom() {
        if (this.pomFoundLicenses != null && this.pomFoundLicenses.size() > 0 && this.pomFoundLicenses.get(0) != null && this.pomFoundLicenses.get(0).getUrl() != null) {
            return this.pomFoundLicenses.get(0).getUrl();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MavenLicense licenseFromPom() {
        MavenLicense mavenLicense;
        if (this.pomFoundLicenses.size() < 1) {
            this.log.warn((CharSequence)"No license will be used in the Studio plugin: No license section was found at pom.xml.");
            return null;
        }
        License mavenLicenseObject = this.pomFoundLicenses.get(0);
        if (mavenLicenseObject == null || mavenLicenseObject.getUrl() == null || mavenLicenseObject.getUrl().equals("")) {
            this.log.warn((CharSequence)"No license will be used in the Studio plugin: No license URL was specified.");
            return null;
        }
        BufferedReader in = null;
        try {
            URL licenseURL = new URL(mavenLicenseObject.getUrl());
            in = new BufferedReader(new InputStreamReader(licenseURL.openStream()));
            mavenLicense = new MavenLicense(IOUtils.toString((Reader)in), mavenLicenseObject.getUrl());
        }
        catch (IOException e) {
            MavenLicense mavenLicense2;
            try {
                this.log.warn((CharSequence)("No license will be used in the Studio plugin: Error reading from the remote URL:  " + e.getLocalizedMessage()));
                mavenLicense2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)in);
            return mavenLicense2;
        }
        IOUtils.closeQuietly((Reader)in);
        return mavenLicense;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readLicenseBodyFromFile(File licensePath) throws IOException {
        String string;
        FileReader licenseReader = null;
        try {
            licenseReader = new FileReader(licensePath);
            string = IOUtils.toString((Reader)licenseReader);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(licenseReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)licenseReader);
        return string;
    }
}

