/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.maven;

import java.text.MessageFormat;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.mule.devkit.maven.RepositoryUtils;

public abstract class AbstractGitHubMojo
extends AbstractMojo {
    protected boolean isDebug() {
        Log log = this.getLog();
        return log != null ? log.isDebugEnabled() : false;
    }

    protected boolean isInfo() {
        Log log = this.getLog();
        return log != null ? log.isInfoEnabled() : false;
    }

    protected void debug(String message) {
        Log log = this.getLog();
        if (log != null) {
            log.debug((CharSequence)message);
        }
    }

    protected void debug(String message, Throwable throwable) {
        Log log = this.getLog();
        if (log != null) {
            log.debug((CharSequence)message, throwable);
        }
    }

    protected void info(String message) {
        Log log = this.getLog();
        if (log != null) {
            log.info((CharSequence)message);
        }
    }

    protected void info(String message, Throwable throwable) {
        Log log = this.getLog();
        if (log != null) {
            log.info((CharSequence)message, throwable);
        }
    }

    protected void warn(String message) {
        Log log = this.getLog();
        if (log != null) {
            log.warn((CharSequence)message);
        }
    }

    protected void warn(String message, Throwable throwable) {
        Log log = this.getLog();
        if (log != null) {
            log.warn((CharSequence)message, throwable);
        }
    }

    protected void error(String message) {
        Log log = this.getLog();
        if (log != null) {
            log.error((CharSequence)message);
        }
    }

    protected void error(String message, Throwable throwable) {
        Log log = this.getLog();
        if (log != null) {
            log.error((CharSequence)message, throwable);
        }
    }

    protected GitHubClient createClient(String host, String userName, String password, String oauth2Token) throws MojoExecutionException {
        GitHubClient client = !StringUtils.isEmpty((String)host) ? new GitHubClient(host) : new GitHubClient();
        if (!StringUtils.isEmpty((String)userName) && !StringUtils.isEmpty((String)password)) {
            if (this.isDebug()) {
                this.debug("Using basic authentication with username: " + userName);
            }
            client.setCredentials(userName, password);
        } else if (!StringUtils.isEmpty((String)oauth2Token)) {
            if (this.isDebug()) {
                this.debug("Using OAuth2 access token authentication");
            }
            client.setOAuth2Token(oauth2Token);
        } else {
            throw new MojoExecutionException("No authentication credentials configured");
        }
        return client;
    }

    protected RepositoryId getRepository(MavenProject project, String owner, String name) throws MojoExecutionException {
        RepositoryId repository = RepositoryUtils.getRepository(project, owner, name);
        if (repository == null) {
            throw new MojoExecutionException("No GitHub repository (owner and name) configured");
        }
        if (this.isDebug()) {
            this.debug(MessageFormat.format("Using GitHub repository {0}", repository.generateId()));
        }
        return repository;
    }
}

