/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.maven;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.eclipse.egit.github.core.Blob;
import org.eclipse.egit.github.core.Commit;
import org.eclipse.egit.github.core.CommitUser;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Reference;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.Tree;
import org.eclipse.egit.github.core.TreeEntry;
import org.eclipse.egit.github.core.TypedResource;
import org.eclipse.egit.github.core.User;
import org.eclipse.egit.github.core.client.RequestException;
import org.eclipse.egit.github.core.service.DataService;
import org.eclipse.egit.github.core.service.UserService;
import org.eclipse.egit.github.core.util.EncodingUtils;
import org.mule.devkit.maven.AbstractGitHubMojo;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;

@Mojo(name="github-upload-doc")
public class GitHubDocMojo
extends AbstractGitHubMojo {
    private static final String BRANCH_DEFAULT = "refs/heads/gh-pages";
    private static final int BUFFER_LENGTH = 8192;
    @Parameter(defaultValue="${branch}")
    private String branch = "refs/heads/gh-pages";
    @Parameter(defaultValue="${path}")
    private String path;
    @Parameter(defaultValue="${message}")
    private String message;
    @Parameter(defaultValue="${github.repositoryName}")
    private String repositoryName;
    @Parameter(defaultValue="${github.repositoryOwner}")
    private String repositoryOwner;
    @Parameter(defaultValue="${github.userName}")
    private String userName;
    @Parameter(defaultValue="${github.password}")
    private String password;
    @Parameter(defaultValue="${github.oauth2Token}")
    private String oauth2Token;
    @Parameter(defaultValue="${github.host}")
    private String host;
    @Parameter(property="github.includes")
    private String[] includes;
    @Parameter(property="github.removeFromPath", defaultValue="")
    private String removeFromPath;
    @Parameter
    private String[] excludes = new String[]{"**/current.xml"};
    @Parameter(property="siteOutputDirectory", defaultValue="${project.build.directory}/apidocs", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project}", required=true)
    private MavenProject project;
    @Parameter(defaultValue="${github.force}")
    private boolean force;
    @Parameter(defaultValue="${github.merge}")
    private boolean merge;
    @Parameter(defaultValue="${github.dryRun}")
    private boolean dryRun;
    @Parameter(property="github.retry.count", defaultValue="3")
    private int retryCount;
    @Parameter(property="github.sleep.time", defaultValue="10000")
    private int sleepTime;
    @Parameter(property="github.fail.build", defaultValue="false")
    private boolean failBuild;
    @Parameter(defaultValue="${reactorProjects}")
    private List<MavenProject> reactorProjects;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException {
        Commit created;
        Tree tree;
        Object[] paths;
        if (this.message == null) {
            this.message = "Updating documentation";
        }
        if (this.host == null) {
            this.host = "api.github.com";
        }
        if (!this.project.getPackaging().equals("mule-module")) {
            if (!this.isDebug()) return;
            this.debug(String.format("Skipping docs upload of project %s because packaging is %s", this.project.getName(), this.project.getPackaging()));
            return;
        }
        RepositoryId repository = this.getRepository(this.project, this.repositoryOwner, this.repositoryName);
        if (this.dryRun) {
            this.info("Dry run mode, repository will not be modified");
        }
        String baseDir = this.outputDirectory.getAbsolutePath();
        Object[] includePaths = GitHubDocMojo.removeEmpties(this.includes);
        Object[] excludePaths = GitHubDocMojo.removeEmpties(this.excludes);
        if (this.isDebug()) {
            this.debug("Includes: " + Arrays.toString(includePaths));
            this.debug(MessageFormat.format("Scanning {0} and including {1} and exluding {2}", baseDir, Arrays.toString(includePaths), Arrays.toString(excludePaths)));
        }
        if ((paths = GitHubDocMojo.getMatchingPaths((String[])includePaths, (String[])excludePaths, baseDir)).length != 1) {
            this.info(MessageFormat.format("Creating {0} blobs", paths.length));
        } else {
            this.info("Creating 1 blob");
        }
        if (this.isDebug()) {
            this.debug(MessageFormat.format("Scanned files to include: {0}", Arrays.toString(paths)));
        }
        DataService service = new DataService(this.createClient(this.host, this.userName, this.password, this.oauth2Token));
        ArrayList<TreeEntry> entries = new ArrayList<TreeEntry>(paths.length);
        String prefix = this.path;
        if (prefix == null) {
            prefix = "";
        }
        if (prefix.length() > 0 && !prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        if ('\\' == File.separatorChar) {
            for (int i = 0; i < paths.length; ++i) {
                paths[i] = ((String)paths[i]).replace('\\', '/');
            }
        }
        for (Object path : paths) {
            TreeEntry entry = new TreeEntry();
            String entryPath = StringUtils.remove((String)path, (String)this.removeFromPath);
            entry.setPath(prefix + entryPath);
            entry.setType("blob");
            entry.setMode("100644");
            if (this.isDebug()) {
                this.debug("Generating entry for " + entry.getPath());
            }
            try {
                String blob = this.createBlob(service, repository, (String)path);
                entry.setSha(blob);
            }
            catch (MojoExecutionException e) {
                if (!this.failBuild) return;
                throw e;
            }
            entries.add(entry);
        }
        Reference ref = null;
        try {
            ref = service.getReference((IRepositoryIdProvider)repository, this.branch);
        }
        catch (RequestException e) {
            if (404 != e.getStatus()) {
                throw new MojoExecutionException("Error getting reference: " + e.getMessage(), (Exception)((Object)e));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error getting reference: " + e.getMessage(), (Exception)e);
        }
        if (ref != null && !"commit".equals(ref.getObject().getType())) {
            throw new MojoExecutionException(MessageFormat.format("Existing ref {0} points to a {1} ({2}) instead of a commmit", ref.getRef(), ref.getObject().getType(), ref.getObject().getSha()));
        }
        try {
            int size = entries.size();
            if (size != 1) {
                this.info(MessageFormat.format("Creating tree with {0} blob entries", size));
            } else {
                this.info("Creating tree with 1 blob entry");
            }
            String baseTree = null;
            if (this.merge && ref != null) {
                Tree currentTree = service.getCommit((IRepositoryIdProvider)repository, ref.getObject().getSha()).getTree();
                if (currentTree != null) {
                    baseTree = currentTree.getSha();
                }
                this.info(MessageFormat.format("Merging with tree {0}", baseTree));
            }
            tree = !this.dryRun ? service.createTree((IRepositoryIdProvider)repository, entries, baseTree) : new Tree();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating tree: " + e.getMessage(), (Exception)e);
        }
        CommitUser committer = this.getCommitUser();
        Commit commit = this.buildCommit(tree, committer);
        if (ref != null) {
            commit.setParents(Collections.singletonList(new Commit().setSha(ref.getObject().getSha())));
        }
        try {
            created = !this.dryRun ? service.createCommit((IRepositoryIdProvider)repository, commit) : new Commit();
            this.info(MessageFormat.format("Creating commit with SHA-1: {0}", created.getSha()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating commit: " + e.getMessage(), (Exception)e);
        }
        TypedResource object = new TypedResource();
        object.setType("commit").setSha(created.getSha());
        if (ref != null) {
            ref.setObject(object);
            try {
                this.info(MessageFormat.format("Updating reference {0} from {1} to {2}", this.branch, ((Commit)commit.getParents().get(0)).getSha(), created.getSha()));
                if (this.dryRun) return;
                service.editReference((IRepositoryIdProvider)repository, ref, this.force);
                return;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error editing reference: " + e.getMessage(), (Exception)e);
            }
        }
        ref = new Reference().setObject(object).setRef(this.branch);
        try {
            this.info(MessageFormat.format("Creating reference {0} starting at commit {1}", this.branch, created.getSha()));
            if (this.dryRun) return;
            service.createReference((IRepositoryIdProvider)repository, ref);
            return;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating reference: " + e.getMessage(), (Exception)e);
        }
    }

    private Commit buildCommit(Tree tree, CommitUser committer) {
        Commit commit = new Commit();
        commit.setMessage(this.message);
        commit.setTree(tree);
        commit.setAuthor(committer);
        commit.setCommitter(committer);
        return commit;
    }

    private CommitUser getCommitUser() throws MojoExecutionException {
        CommitUser committer = new CommitUser();
        try {
            User current = new UserService().getUser(this.userName);
            committer.setDate(Calendar.getInstance().getTime());
            committer.setName(current.getName());
            committer.setEmail(current.getEmail());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error retrieving github user information: " + e.getMessage());
        }
        return committer;
    }

    private String createBlob(DataService service, RepositoryId repository, String path) throws MojoExecutionException {
        File file = new File(this.outputDirectory, path);
        long length = file.length();
        int size = length > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)length;
        ByteArrayOutputStream output = new ByteArrayOutputStream(size);
        FileInputStream stream = null;
        try {
            int read;
            stream = new FileInputStream(file);
            byte[] buffer = new byte[8192];
            while ((read = stream.read(buffer)) != -1) {
                output.write(buffer, 0, read);
            }
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error reading file: " + e.getMessage(), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)stream);
        Blob blob = new Blob().setEncoding("base64");
        blob.setContent(EncodingUtils.toBase64((byte[])output.toByteArray()));
        try {
            if (this.isDebug()) {
                this.debug(MessageFormat.format("Creating blob from {0}", file.getAbsolutePath()));
            }
            if (!this.dryRun) {
                return this.uploadBlobRetryIfError(service, repository, blob);
            }
            return null;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating blob: " + e.getMessage(), (Exception)e);
        }
    }

    private String uploadBlobRetryIfError(DataService service, RepositoryId repository, Blob blob) throws IOException, MojoExecutionException {
        for (int i = 0; i < this.retryCount; ++i) {
            try {
                return service.createBlob((IRepositoryIdProvider)repository, blob);
            }
            catch (IOException e) {
                this.warn(String.format("Exception caught while uploading the documentation to GitHub, %s retries left", this.retryCount - i - 1), e);
                this.sleep(this.sleepTime);
                continue;
            }
        }
        this.error("Cannot upload documentation to GitHub after retrying");
        throw new MojoExecutionException("Cannot upload documentation to GitHub after retrying");
    }

    public static String[] removeEmpties(String ... values) {
        if (values == null || values.length == 0) {
            return new String[0];
        }
        ArrayList<String> validValues = new ArrayList<String>();
        for (String value : values) {
            if (value == null || value.length() <= 0) continue;
            validValues.add(value);
        }
        return validValues.toArray(new String[validValues.size()]);
    }

    public static String[] getMatchingPaths(String[] includes, String[] excludes, String baseDir) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(baseDir);
        if (includes != null && includes.length > 0) {
            scanner.setIncludes(includes);
        }
        if (excludes != null && excludes.length > 0) {
            scanner.setExcludes(excludes);
        }
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    private void sleep(int sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

